<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PagingGridView.aspx.cs" Inherits="PagingGridView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Stronicowanie w kontrolce GridView</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css">
      .box {
         margin: 1em 0; border: solid 1pt silver; padding: 0.5em;
      }
      
      .bookList { border: solid 1pt #DEDFDE; }
      .bookListRow { background-color: #F7F7DE; }
      .bookListSelected { background-color:#CE5D5A; font-weight: bold; color: White; }
      .bookListPager { background-color:#F7F7DE; font-weight: bold; color: Black; }
      .bookListHeader { background-color:#6B696B; font-weight: bold; color: White; }
      .bookListAlt { background-color: white; }
      
      .detail { border: solid 1pt #DEDFDE; }
      .detailLabel { font-weight: bold; }
      .detailRow { background-color: #F7F7DE; }
      .detailHeader { background-color:#6B696B; font-weight: bold; color: White; }
      .detailAlt { background-color: white; }      
   </style>
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
         <h1>Stronicowanie w kontrolce GridView</h1>
         <p>
         W przykadzie pokazano, jak uy kontrolki <code>ObjectDataSource</code>
         w celu uzyskania dodatkowych funkcji
         </p>
         <div class="box">
            <asp:GridView ID="grdBookList" runat="server" DataSourceID="dsBooks"
              AutoGenerateColumns="False" 
              AllowPaging="true" PageSize="4"
              DataKeyNames="Isbn"
              Width="600" CssClass="bookList"
              CellPadding="4" GridLines="Vertical" >

               <Columns>
                  <asp:CommandField ShowSelectButton="true" ButtonType="Image"
                     SelectImageUrl="images/btn_select.gif"/>
                  <asp:ImageField HeaderText="" DataImageUrlField="Isbn" 
                     DataImageUrlFormatString="images/{0}.gif"
                     DataAlternateTextField="Title" 
                     DataAlternateTextFormatString="Okadka {0}"
                     ReadOnly="True" />              
                  <asp:BoundField DataField="Title" HeaderText="Tytu"/>           
               </Columns>
               <RowStyle CssClass="bookListRow" />
               <SelectedRowStyle CssClass="bookListSelected" />
               <PagerStyle  CssClass="bookListPager" HorizontalAlign="Center"/>
               <PagerSettings Mode="NextPrevious" NextPageText=">" PreviousPageText="<" />
               <HeaderStyle CssClass="bookListHeader" />
               <AlternatingRowStyle CssClass="bookListAlt" />
            </asp:GridView>  
         </div> 

                              
      </div>
<asp:ObjectDataSource ID="dsBooks" runat="server"
   TypeName="BookDA" SelectMethod="GetAll" SelectCountMethod="CountBooks"
   EnablePaging="true" MaximumRowsParameterName="rowsToRetrieve"
   StartRowIndexParameterName="startRowIndex">
		   
		</asp:ObjectDataSource>
		   
			 
   </form>
</body>
</html>

