<%@ Page Language="C#" AutoEventWireup="true" CodeFile="EditGridView.aspx.cs" Inherits="EditGridView" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Edycja w kontrolce GridView</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css">
      .box {
         margin: 1em 0; border: solid 1pt silver; padding: 0.5em;
      }
      
      .bookList { border: solid 1pt #DEDFDE; }
      .bookListRow { background-color: #F7F7DE; }
      .bookListSelected { background-color:#CE5D5A; font-weight: bold; color: White; }
      .bookListPager { background-color:#F7F7DE; font-weight: bold; color: Black; }
      .bookListHeader { background-color:#6B696B; font-weight: bold; color: White; }
      .bookListAlt { background-color: white; }
         
   </style>
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
         <h1>Edycja w kontrolce GridView</h1>
         <p>
         W przykadzie pokazano, jak w kontrolce <code>GridView</code> wczy funkcj edycji bezporedniej.
         </p>
         <asp:GridView ID="grdSample" runat="server" DataSourceID="dsBooks"
           AutoGenerateColumns="False"   DataKeyNames="ISBN"
           AutoGenerateEditButton="false" AllowPaging="true" PageSize="4"
           CssClass="bookList" ShowFooter="true" ShowHeader="true"
           CellPadding="4" GridLines="Vertical" >

            <Columns> 
               <asp:CommandField ButtonType="Image" 
                   ShowEditButton="true" 
                   EditImageUrl="images/btn_edit.gif"
                   CancelImageUrl="images/btn_cancel.gif"  
                   UpdateImageUrl="images/btn_update.gif"    />
               <asp:BoundField DataField="Isbn" HeaderText="Isbn" ReadOnly="true"/>
               <asp:TemplateField HeaderText="Tytu">                 
                  <ItemTemplate> 
                     <%# Eval("Title") %>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:TextBox ID="txtTitle" runat="server" Columns="40" 
                       Rows="2" TextMode="MultiLine"
                       Text='<%# Bind("Title") %>' />
                     <br />
                     <asp:RequiredFieldValidator ID="reqTitle" runat="server"
                         ControlToValidate="txtTitle"
                         ErrorMessage="Musisz wprowadzi tytu" />
                  </EditItemTemplate>
               </asp:TemplateField>                 
               <asp:TemplateField HeaderText="Wydawca">                 
                  <ItemTemplate> 
                     <%# Eval("PublisherName") %>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:DropDownList ID="drpPublisher" runat="server" 
                       DataSourceID="dsPublisher" DataValueField="PublisherId"
                       DataTextField="PublisherName" 
                       SelectedValue='<%# Bind("PublisherId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>                  
               <asp:TemplateField HeaderText="Rok">                 
                  <ItemTemplate> 
                     <%# Eval("YearPublished") %>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:TextBox ID="txtYear" runat="server" Columns="3" 
                       Text='<%# Bind("YearPublished") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>                         
            </Columns>
            <RowStyle CssClass="bookListRow" />
            <SelectedRowStyle CssClass="bookListSelected" />
            <PagerStyle  CssClass="bookListPager" HorizontalAlign="Center"/>
            <PagerSettings Mode="NextPrevious" NextPageText=">" PreviousPageText="<" />
            <HeaderStyle CssClass="bookListHeader" />
            <AlternatingRowStyle CssClass="bookListAlt" />
         </asp:GridView>               
      </div>
      <asp:SqlDataSource ID="dsBooks" runat="server" ProviderName="System.Data.SqlClient" ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
         SelectCommand="SELECT ISBN,Title,PublisherName,Books.PublisherId,YearPublished,BriefDescription FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId"
         UpdateCommand="UPDATE Books SET Title=@Title,PublisherId=@PublisherId,YearPublished=@YearPublished,BriefDescription=@BriefDescription WHERE ISBN=@ISBN">
         
         <UpdateParameters>
            <asp:Parameter Name="ISBN" Type="String" />
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="PublisherId" Type="Int32" />
            <asp:Parameter Name="YearPublished" Type="Int32" />
            <asp:Parameter Name="BriefDescription" Type="String" />
         </UpdateParameters>         
         
      </asp:SqlDataSource>
      
      <asp:SqlDataSource ID="dsPublisher" runat="server"
             ProviderName="System.Data.OleDb" 
             ConnectionString="<%$ ConnectionStrings:Books %>"
             SelectCommand="Select PublisherId,PublisherName From Publishers" />       
   </form>
</body>
</html>
