<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ButtonGridView.aspx.cs" Inherits="ButtonGridView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>ButtonField GridView</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css">
      .cartBox { margin: 1em 0; padding: 0.5em; border: 1pt solid silver; }
   </style>
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
         <h1>Klasa ButtonField w kontrolce GridView</h1>
         <p>
         W przykadzie pokazano, jak uywa klasy <code>ButtonField</code> 
         w kontrolce <code>GridView</code>.
         </p>
         <asp:GridView ID="grdSample" runat="server" DataSourceID="dsBooks"
           AutoGenerateColumns="False" BackColor="White"
           AllowPaging="true" PageSize="5"
           BorderColor="#DEDFDE" BorderStyle="None" BorderWidth="1px" 
           CellPadding="4" GridLines="Vertical" ForeColor="Black" DataKeyNames="Isbn,Title" OnRowCommand="grdSample_RowCommand">

            <Columns>
               <asp:ImageField DataImageUrlField="Isbn" 
                  DataImageUrlFormatString="images/{0}.gif"
                  DataAlternateTextField="Tytu" 
                  DataAlternateTextFormatString="Okadka {0}"
                  ReadOnly="True" />                              
               <asp:BoundField DataField="ISBN" HeaderText="Isbn" ReadOnly="True"/>                
               <asp:BoundField DataField="Title" HeaderText="Tytu"/>   
               <asp:ButtonField ButtonType="Image" CommandName="AddCart"
                  ImageUrl="images/btn_addToCart.gif"   />             
            </Columns>
            <FooterStyle BackColor="#CCCC99" />
            <RowStyle BackColor="#F7F7DE" />
            <SelectedRowStyle BackColor="#CE5D5A" Font-Bold="True" ForeColor="White" />
            <PagerStyle BackColor="#F7F7DE" ForeColor="Black" HorizontalAlign="Right" />
            <HeaderStyle BackColor="#6B696B" Font-Bold="True" ForeColor="White" />
            <AlternatingRowStyle BackColor="White" />
         </asp:GridView>    
         <div class="cartBox">
            <h2>Request Cart Contents</h2>
            <asp:GridView ID="grdCart" runat="server" CellPadding="5"
               AutoGenerateColumns="false" BorderWidth="0">

               <Columns>
                  <asp:BoundField DataField="Isbn" HeaderText="Isbn" />
                  <asp:BoundField DataField="Title" HeaderText="Tytu" />
               </Columns>
            </asp:GridView>           
         </div>
      </div>
<asp:SqlDataSource ID="dsBooks" runat="server"
	 ProviderName="System.Data.SqlClient" 
	 ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
	 SelectCommand="SELECT ISBN,Title,PublisherName,YearPublished FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId" />
   </form>
</body>
</html>

