<%@ Page Language="C#" AutoEventWireup="true" CodeFile="BookDetails.aspx.cs" Inherits="BookDetails" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
	<title>Edycja w kontrolce FormView</title>
	<link href="chapterStyles.css" type="text/css" rel="stylesheet" />
	<style type="text/css">
		.dataValues { font-weight: bold; }
		.singleBook { border-top: 1pt solid #E7E7E7;
		              border-left: 1pt solid #E7E7E7;
		              border-bottom: 1pt solid #D2D2D2;
		              border-right: 1pt solid #D2D2D2;
		              padding: 1em;	
		              margin: 1em;              
		              background: #FFFFE0;		              
		               }
		 .singleBookTitle {
                    vertical-align: middle;
                    text-align: center;
		              background: #FFFFCC;
		              }
		  .entireForm {
		            border: 2pt solid #D7D7D7; 
		  }
	</style>
</head>
<body>
	<form id="form1" runat="server">
		<div id="container">
		   <h1 class="singleBookTitle">Informacje o ksice</h1>
         <asp:FormView ID="frmvBooks" runat="server" DataSourceID="dsBooks" 
               CssClass="entireForm" AllowPaging="true" DataKeyNames="Isbn">

	         <ItemTemplate>
		         <div class="singleBook">
		         ISBN: <br />
		         <asp:Label ID="labIsbn" runat="server"
		           Text='<%# Eval("ISBN") %>' CssClass="dataValues" /><br />
		         Title:<br />
		         <asp:Label ID="labTitle" runat="server"
		           Text='<%# Eval("Title") %>' CssClass="dataValues" /><br />
		         Publisher:<br />
		         <asp:Label ID="labPublisher" runat="server"
		           Text='<%# Eval("PublisherName") %>' CssClass="dataValues" /><br />
		         Year:<br />
	            <asp:Label ID="labYear" runat="server"
		           Text='<%# Eval("YearPublished") %>' CssClass="dataValues" /><br />
		         Description:<br />
	            <asp:Label ID="txtDecs" runat="server"
		           Text='<%# Eval("BriefDescription") %>' CssClass="dataValues" /><br />             
		         </div>
	         </ItemTemplate>
            <EmptyDataTemplate>
               Niestety, podanemu numerowi ISBN nie odpowiada adna ksika
            </EmptyDataTemplate>
	         
            
            <PagerStyle CssClass="singleBookTitle" />
            <PagerSettings Mode="NextPreviousFirstLast" 
               FirstPageImageUrl="images/page_first.gif"
               LastPageImageUrl="images/page_last.gif"
               NextPageImageUrl="images/page_next.gif"
               PreviousPageImageUrl="images/page_previous.gif"/>
         </asp:FormView>

		</div>
      <asp:SqlDataSource ID="dsBooks" runat="server"
	       ProviderName="System.Data.OleDb" 
	       ConnectionString="<%$ ConnectionStrings:Books %>"
	       SelectCommand="SELECT ISBN,Title,PublisherName,Books.PublisherId,YearPublished,BriefDescription FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId WHERE ISBN=@isbn">

         <SelectParameters>
            <asp:QueryStringParameter Name="isbn" QueryStringField="id" />
         </SelectParameters>			 
      	 
      </asp:SqlDataSource>
                   

	</form>
</body>
</html>

