using System;
using System.Data;
using System.Data.Common;

/// <summary>
/// Oglny opis klasy BookDA
/// </summary>
public class BookDA: AbstractDA 
{
   protected override string SelectStatement
   {
      get {
         return "SELECT ISBN,Title,PublisherName,Books.PublisherId,YearPublished,BriefDescription FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId";
      }
   }

   /// <summary>
   /// Zwraca ca okrelon stron danych
   /// </summary>
   public DataTable GetAll(int startRowIndex, int rowsToRetrieve)
   {
      // uyj procedury skadowanej w celu pobrania wycznie potrzebnych danych
      string storedProc = "GetAllBooksByPage";

      // utwrz tabel parametrw
      DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@startRowIndex", startRowIndex, DbType.Int32),
         MakeParameter("@rowsToRetrieve", rowsToRetrieve, DbType.Int32)
	   };

      // zwr wynik
      return GetDataTable(storedProc, CommandType.StoredProcedure, parameters);
   }

   /// <summary>
   /// Zwraca ca okrelon stron danych
   /// </summary>
   public DataTable GetAll(string sortExpression)
   {
      string sql = SelectStatement;
      if (sortExpression.Length > 0)
         sql += " ORDER BY " + sortExpression;
      return GetDataTable(sql, null);
   }


   /// <summary>
   /// Zwraca czn liczb rekordw z ksikami
   /// </summary>
   /// <returns></returns>
   public int CountBooks()
   {
      string sql = "SELECT COUNT(*) FROM Books";

      return (int)RunScalar(sql, null);
   }

   /// <summary>
   /// Zwraca tabel danych zawierajc informacje o tabeli z ksik o danym isbn.
   /// Zbir danych bdzie zawiera 0 albo 1 wiersz danych.
   /// </summary>
   public DataTable GetBooksByIsbn(string isbn)
   {
      // utwrz sparametryzowan instrukcj zapytania
      string sql = SelectStatement + " WHERE ISBN=@isbn";

      // utwrz tabel parametrw
      DbParameter[] parameters = new DbParameter[] {
			MakeParameter("@isbn", isbn, DbType.String)
															};
      // zwr wynik
      return GetDataTable(sql, parameters);
   }

   /// <summary>
   /// Aktualizuje wybrane wartoci ksiki
   /// </summary>
   public void UpdateBook(string isbn, string title, int publisherId, int yearPublished, string briefDescription)
   {
      string sql = "UPDATE Books SET Title=@Title,PublisherId=@PublisherId,";
      sql += "YearPublished=@YearPublished,BriefDescription=@BriefDescription";
      sql += " WHERE ISBN=@isbn";

      // utwrz tabel parametrw
      DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@isbn", isbn, DbType.String),
         MakeParameter("@Title", title, DbType.String),
         MakeParameter("@PublisherId", publisherId, DbType.Int32),
         MakeParameter("@YearPublished", yearPublished, DbType.Int32),
         MakeParameter("@BriefDescription", briefDescription, DbType.String)
														   };
      // wykonaj okrelone polecenie
      RunNonQuery(sql, parameters);
   }

   /// <summary>
   /// Zwraca tabel danych zawierajc informacje o tabeli z ksik o danym identyfikatorze.
   /// Zbir danych bdzie zawiera 0 albo 1 wiersz danych.
   /// </summary>
   public DataTable GetBooksByPublisher(int id)
   {
      // utwrz sparametryzowan instrukcj zapytania
      string sql = SelectStatement + " WHERE Books.PublisherId=@id";

      // utwrz tabel parametrw
      DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@id", id, DbType.Int32)
														   };
      // zwr wynik
      return GetDataTable(sql, parameters);
   }
}
