using System;

/// <summary>
/// Encapsulates the data for a single publisher
/// </summary>
public class Publisher: AbstractEntity 
{
   // data members
   private string _name;

   public Publisher(int id, string name)
      : base(id)
	{
      _name = name;
	}
   public string Name
   {
      get { return _name; }
      set { _name = value; }
   }

   public override string ToString()
   {
      return Id + "," + Name;
   }

   /// <summary>
   /// Determines if this object's state is valid
   /// </summary>
   public override bool IsValid
   {
      get {
         if (Name.Length > 0)
            return true;
         else
            return false;
      }
   }
}
