using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;


/// <summary>
/// Hermetyzuje dane jednego klienta
/// </summary>
public class Book: AbstractEntity 
{
   // dane skadowe
   private string _isbn;
   private string _title;
   private Publisher _publisher;
   private int _year;

   public Book(string isbn, string title, Publisher publisher, int year)
      : base()
   {
      _isbn = isbn;
      _title = title;
      _publisher = publisher;
      _year = year;
   }


   public string Isbn
   {
      get { return _isbn; }
      set { _isbn = value; }
   }
   public string Title
   {
      get { return _title; }
      set { _title = value; }
   }
   public Publisher BookPublisher
   {
      get { return _publisher; }
      set { _publisher = value; }
   }
   public int Year
   {
      get { return _year; }
      set { _year = value; }
   }


   public override bool IsValid
   {
      get
      {
         if (Isbn.Length > 0 && Title.Length > 0 && BookPublisher != null)
            return true;
         else
            return false;
      }
   }

   public override string ToString()
   {
      return Isbn + "," + Title; 
   }
}
