using System;


using System.Collections;

/// <summary>
/// Represents a sample custom strongly-typed collection of customers
/// </summary>
public class CustomerCollection: IEnumerable
{
   // data member
   private ArrayList _customers;

   /// <summary>
   /// Constructor initializes the internal collection
   /// </summary>
	public CustomerCollection()
	{
      _customers = new ArrayList();
	}

   /// <summary>
   /// Add a customer to the collection
   /// </summary>
   public void Add(Customer c)
   {
      if (c != null)
         _customers.Add(c);
   }

   /// <summary>
   /// Indexer that allows a collection element to be retrieved by a numeric index
   /// </summary>
   public Customer this[int index]
   {
      get {
         if (index >= 0 && index < _customers.Count)
            return (Customer)_customers[index];
         else
            return null;
      }
   }

   /// <summary>
   /// Search for the customer with the passed id value
   /// </summary>
   public Customer FindById(string id)
   {
      foreach (Customer c in _customers)
      {
         if (c.Id == id)
            return c;
      }
      return null;
   }

   /// <summary>
   /// Implementing this interface allows collection to be iterated using a foreach
   /// (and thus allows collection to be used for data binding)
   /// </summary>
   public IEnumerator GetEnumerator()
   {
      return _customers.GetEnumerator();
   }
}
