<%@ Page Language="C#" AutoEventWireup="true" CodeFile="SynchronizedMenus.aspx.cs" Inherits="SynchronizedMenus" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Synchronized Menu</title>
    <link href="chapterStyles.css" type="text/css" rel="stylesheet"/>
    <style type="text/css">
      /* styles for the primary menu at top */
      #primaryMenuBlock
      {
         width: 100%;
         /* background: #d6eef5; */
         background: white;
         border-bottom: solid 1pt #75804d;
      }
      .primaryStaticMenu
      {
         background: white;
      }
      .primaryStaticMenuItem
      {
         width: 8em;
         background-color: #a4cad5; 
         border-width: 1px;
         border-color: #d6eef5 #d6eef5 #cad5a4 #d6eef5;
         border-style: solid solid none solid;
         color: #4d7480;
         padding: 0.5em 0 0.5em 1em;
      }
      .primaryStaticHover
      {
         color: #800000;
         background: #d6eef5;
      }
      
      
      #secondaryMenuBlock
      {
         width: 100%;
         background: #cad5a4;
      }
      .secondaryStaticMenu
      {
         background: #cad5a4;
         color: #75804d;
         height: 2em;
         margin-left: 1em;
      }
      .secondaryStaticMenuItem
      {
         padding-right: 1em;
         color: #75804d;
      } 
      .secondaryStaticHover
      {
         color: #800000;
      }           
      .secondaryDynamicMenu
      {
         border: solid 1pt #75804d;
      }
      .secondaryDynamicMenuItem
      {
         background: #eef5d6;
         color: #75804d;
         width: 12em;
      }      
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div id="container">
      <h1>Synchronized Menu Example</h1>
      <p>This example illustrates how to synchronize two <code>Menu</code> controls.</p>
    
      <div id="primaryMenuBlock">
<asp:Menu id="menuPrimary" runat="server" DataSourceID="sitePrimary" 
  Orientation="Horizontal"  StaticEnableDefaultPopOutImage="False" 
  MaximumDynamicDisplayLevels="0" OnMenuItemClick="menuPrimary_MenuItemClick">
   <DataBindings>
      <asp:MenuItemBinding DataMember="SiteMapNode" TextField="Title" />
   </DataBindings>
         <StaticMenuStyle CssClass="primaryStaticMenu"/>
         <StaticMenuItemStyle CssClass="primaryStaticMenuItem"/>
         <StaticHoverStyle CssClass="primaryStaticHover"/>
      </asp:Menu>
      </div>
      <div id="secondaryMenuBlock">
      <asp:Menu id="menuSecondary" runat="server" DataSourceID="siteSecondary" 
        Orientation="Horizontal" >
      
        <StaticMenuStyle CssClass="secondaryStaticMenu"/>  
        <StaticMenuItemStyle CssClass="secondaryStaticMenuItem"/> 
        <StaticHoverStyle CssClass="secondaryStaticHover"/>
        <DynamicMenuStyle CssClass="secondaryDynamicMenu"/>
        <DynamicMenuItemStyle CssClass="secondaryDynamicMenuItem" />
      </asp:Menu>
      </div>
        
      <asp:SiteMapDataSource ID="sitePrimary" runat="server" SiteMapProvider="SynchronizedSiteMap"
         ShowStartingNode="false" />
       
      <asp:SiteMapDataSource ID="siteSecondary" runat="server" 
         ShowStartingNode="false" 
         StartingNodeURL="Default.aspx?node=hardware"
         StartingNodeOffset="-1"
         SiteMapProvider="SynchronizedSiteMap"/> 
    </div>
    </form>
</body>
</html>
