<%@ Application Language="C#" %>

<script runat="server">

/// <summary>
/// Procedura obsugi zdarzenia wywoywana w czasie uruchamiania aplikacji (czyli, przy
/// pierwszym wywoaniu dowolnej strony aplikacji)
/// </summary>
void Application_Start(object sender, EventArgs e) 
{
 SiteMap.SiteMapResolve += new SiteMapResolveEventHandler(ModifyProductSiteMapNode);

  //SiteMap.SiteMapResolve += new SiteMapResolveEventHandler(AppendComplexQueryString);
}

/// <summary>
/// Procedura obsugi zdarzenia modyfikowania wza produktw w mapie witryny
/// </summary>
public SiteMapNode ModifyProductSiteMapNode(object o, SiteMapResolveEventArgs e)
{
   // Jeeli bieca strona nie znajduje si w mapie witryny, ignorujemy j
   if (SiteMap.CurrentNode == null)
      return null;
   
   // Wykonanie kopii SiteMapNode
   SiteMapNode temp = SiteMap.CurrentNode.Clone(true);

   // Jeeli biecy wze SiteMapNode nie jest wzem produktw, pozostawiamy go i koczymy prac
   if (temp.Title != "Produkt")
      return temp;

   // Pobranie identyfikatora produktu z cigu zapytania
   string sId = e.Context.Request.QueryString["prod"];
   // Jeeli brak cigu zapytania, pozostawiamy wze bez zmian
   if (sId == null)
      return temp;

   // Uycie obiektu biznesowego do pobrania wypenionego obiektu Product
   Product prod = ProductCatalog.GetProductById(Convert.ToInt32(sId));

   // Jeeli udao si odczytanie produktu, zmieniamy
   // tytu wza na nazw produktu
   if (prod != null)
      temp.Title = prod.Name;

   // Zwracamy zmodyfikowany wze
   return temp;
}


   
   
   // following methods used for the more complex example
    
	public SiteMapNode AppendComplexQueryString(object o, SiteMapResolveEventArgs e) 
   {
		if (SiteMap.CurrentNode != null) {
			SiteMapNode temp;
			temp = SiteMap.CurrentNode.Clone(true);
			Uri u = new Uri(e.Context.Request.Url.ToString());
         
         // retrieve the group title from the 
         string groupTitle = RetrieveGroupTitle(e);
         string subTitle = RetrieveSubHeadingTitle(e);
         string bookTitle = RetrieveBookTitle(e);

         if (temp.Title == "Group" && groupTitle != null)
            temp.Title = groupTitle;

         if (temp.Title == "SubHeading" && subTitle != null)
         {
            temp.Title = subTitle;
            if (groupTitle != null)
               temp.ParentNode.Title = groupTitle;
         }

         if (temp.Title == "Book" && bookTitle != null)
         {
            temp.Title = bookTitle;
            if (subTitle != null)
               temp.ParentNode.Title = subTitle;
            if (groupTitle != null)
               temp.ParentNode.ParentNode.Title = groupTitle;
         }         
      
         
			temp.Url += u.Query;
			if (temp.ParentNode != null) {
				temp.ParentNode.Url += u.Query;
			}
			
			return temp;
		} else {
			return null;
		}
	}

   private string RetrieveGroupTitle(SiteMapResolveEventArgs e)
   {
      string sGroup = e.Context.Request.QueryString["grp"];
      if (sGroup == null)
         return null;

      return Catalog.GetGroupNameById(Convert.ToInt32(sGroup)); 
   }

   private string RetrieveSubHeadingTitle(SiteMapResolveEventArgs e)
   {
      string sItem = e.Context.Request.QueryString["sub"];
      if (sItem == null)
         return null;

      return Catalog.GetSubHeadingNameById(Convert.ToInt32(sItem));
   }

   private string RetrieveBookTitle(SiteMapResolveEventArgs e)
   {
      string sId = e.Context.Request.QueryString["id"];
      if (sId == null)
         return null;

      return Catalog.GetBookNameById(Convert.ToInt32(sId));
   }     
       
</script>
