using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Drawing;

public partial class UsingStyle : System.Web.UI.Page
{
   private Style primaryStyle = new Style();

   protected void Page_Load(object sender, System.EventArgs e)
   {
      if (!Page.IsPostBack)
      {
         // Add data to the borderColorList, 
         // backColorList, and foreColorList controls.
         ListItemCollection colors = new ListItemCollection();
         colors.Add(Color.Black.Name);
         colors.Add(Color.Blue.Name);
         colors.Add(Color.Green.Name);
         colors.Add(Color.Orange.Name);
         colors.Add(Color.Purple.Name);
         colors.Add(Color.Red.Name);
         colors.Add(Color.White.Name);
         colors.Add(Color.Yellow.Name);
         borderColorList.DataSource = colors;
         borderColorList.DataBind();
         backColorList.DataSource = colors;
         backColorList.DataBind();
         foreColorList.DataSource = colors;
         foreColorList.DataBind();

         // Add data to the borderStyleList control.
         ListItemCollection styles = new ListItemCollection();
         Type styleType = typeof(BorderStyle);
         foreach (string s in Enum.GetNames(styleType))
         {
            styles.Add(s);
         }
         borderStyleList.DataSource = styles;
         borderStyleList.DataBind();

         // Add data to the borderWidthList control.
         ListItemCollection widths = new ListItemCollection();
         for (int i = 0; i < 11; i++)
         {
            widths.Add(i.ToString() + "px");
         }
         borderWidthList.DataSource = widths;
         borderWidthList.DataBind();

         // Add data to the fontNameList control.
         ListItemCollection names = new ListItemCollection();
         names.Add("Arial");
         names.Add("Courier");
         names.Add("Garamond");
         names.Add("Time New Roman");
         names.Add("Verdana");
         fontNameList.DataSource = names;
         fontNameList.DataBind();

         // Add data to the fontSizeList control.
         ListItemCollection fontSizes = new ListItemCollection();
         fontSizes.Add("Small");
         fontSizes.Add("Medium");
         fontSizes.Add("Large");
         fontSizes.Add("10pt");
         fontSizes.Add("14pt");
         fontSizes.Add("20pt");
         fontSizeList.DataSource = fontSizes;
         fontSizeList.DataBind();

         //Set primaryStyle as the style for each control.
         Label1.ApplyStyle(primaryStyle);
         ListBox1.ApplyStyle(primaryStyle);
         Button1.ApplyStyle(primaryStyle);
         Table1.ApplyStyle(primaryStyle);
         TextBox1.ApplyStyle(primaryStyle);
      }
   }
   protected void ChangeBorderColor(object sender, System.EventArgs e)
   {
      primaryStyle.BorderColor =
          Color.FromName(borderColorList.SelectedItem.Text);
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

   protected void ChangeBackColor(object sender, System.EventArgs e)
   {
      primaryStyle.BackColor =
          Color.FromName(backColorList.SelectedItem.Text);
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

   protected void ChangeForeColor(object sender, System.EventArgs e)
   {
      primaryStyle.ForeColor =
          Color.FromName(foreColorList.SelectedItem.Text);
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

   protected void ChangeBorderStyle(object sender, System.EventArgs e)
   {
      primaryStyle.BorderStyle =
          (BorderStyle)Enum.Parse(typeof(BorderStyle),
          borderStyleList.SelectedItem.Text);
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

   protected void ChangeBorderWidth(object sender, System.EventArgs e)
   {
      primaryStyle.BorderWidth =
          Unit.Parse(borderWidthList.SelectedItem.Text);
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

   protected void ChangeFont(object sender, System.EventArgs e)
   {
      primaryStyle.Font.Name =
          fontNameList.SelectedItem.Text;
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

   protected void ChangeFontSize(object sender, System.EventArgs e)
   {
      primaryStyle.Font.Size =
          FontUnit.Parse(fontSizeList.SelectedItem.Text);
      Label1.ApplyStyle(primaryStyle);
      ListBox1.ApplyStyle(primaryStyle);
      Button1.ApplyStyle(primaryStyle);
      Table1.ApplyStyle(primaryStyle);
      TextBox1.ApplyStyle(primaryStyle);
   }

}
