using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Drawing;

public partial class PropertyTester : System.Web.UI.Page
{
   private Style _styleToApply = new Style();

   protected void Page_Load(object sender, EventArgs e)
   {
   }

   // event handlers

   /// <summary>
   /// Handler for the visibility checkbox
   /// </summary>
   protected void chkVisible_CheckedChanged(object sender, EventArgs e)
   {
      if (chkVisible.Checked)
         ChangeVisible(true);
      else
         ChangeVisible(false);
   }
   /// <summary>
   /// Handler for the enabled checkbox
   /// </summary>
   protected void chkEnabled_CheckedChanged(object sender, EventArgs e)
   {
      if (chkEnabled.Checked)

         ChangeEnabled(true);
      else
         ChangeEnabled(false);
   }
   /// <summary>
   /// Handler for the foreground (text) color DropDownList
   /// </summary>
   protected void drpTextColor_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpTextColor.SelectedIndex > 0)
      {
         _styleToApply.ForeColor = Color.FromName(drpTextColor.SelectedValue);
         ApplyNewStyle(_styleToApply);
      }

   }
   /// <summary>
   /// Handler for the background color DropDownList
   /// </summary>
   protected void drpBackgroundColor_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpBackgroundColor.SelectedIndex > 0)
      {
         _styleToApply.BackColor = Color.FromName(drpBackgroundColor.SelectedValue);
         ApplyNewStyle(_styleToApply);
      } 

   }
   /// <summary>
   /// Handler for the font DropDownList
   /// </summary>
   protected void drpFont_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpFont.SelectedIndex > 0)
      {
         _styleToApply.Font.Name = drpFont.SelectedValue; 
         ApplyNewStyle(_styleToApply);
      }
   }
   /// <summary>
   /// Handler for the font size DropDownList
   /// </summary>
   protected void drpFontSize_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpFontSize.SelectedIndex > 0)
      {
         int fontSize = Convert.ToInt32(drpFontSize.SelectedValue);
         _styleToApply.Font.Size = FontUnit.Point(fontSize);
         ApplyNewStyle(_styleToApply);
      } 
   }
   /// <summary>
   /// Handler for the border style DropDownList
   /// </summary>
   protected void drpBorderStyle_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpBorderStyle.SelectedIndex > 0)
      {
         string currBorderStyle = drpBorderStyle.SelectedValue;
         if (currBorderStyle == "dashed")
            _styleToApply.BorderStyle = BorderStyle.Dashed;
         else if (currBorderStyle == "inset")
            _styleToApply.BorderStyle = BorderStyle.Inset;
         else if (currBorderStyle == "none")
            _styleToApply.BorderStyle = BorderStyle.None;
         else if (currBorderStyle == "outset")
            _styleToApply.BorderStyle = BorderStyle.Outset;
         else if (currBorderStyle == "solid")
            _styleToApply.BorderStyle = BorderStyle.Solid;

         ApplyNewStyle(_styleToApply);
      } 
   }
   /// <summary>
   /// Handler for the border width DropDownList
   /// </summary>
   protected void drpBorderWidth_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpBorderWidth.SelectedIndex > 0)
	   {
		   int borderSize = Convert.ToInt32(drpBorderWidth.SelectedValue);
		   _styleToApply.BorderWidth = Unit.Pixel(borderSize);
		   ApplyNewStyle(_styleToApply);
	   } 
   }

   // helper methods

   /// <summary>
   /// Applies our style to the demonstration controls
   /// </summary>
   private void ApplyNewStyle(Style styleToSet)
   {
      labHere.ApplyStyle(styleToSet);
      labAnother.ApplyStyle(styleToSet);
      txtBox.ApplyStyle(styleToSet);
      btnSample.ApplyStyle(styleToSet);
   }
   /// <summary>
   /// Changes the visibility of the demonstration controls
   /// </summary>
   private void ChangeVisible(bool which)
   {
      labHere.Visible = which;
      labAnother.Visible = which;
      txtBox.Visible = which;
      btnSample.Visible = which;
   }
   /// <summary>
   /// Enables or disables the demonstration controls
   /// </summary>
   private void ChangeEnabled(bool which)
   {
      labHere.Enabled = which;
      labAnother.Enabled = which;
      txtBox.Enabled = which;
      btnSample.Enabled = which;
   }	
}
