using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class GroupingValidators : System.Web.UI.Page
{
   /// <summary>
   /// Procedura obsugi przycisku wyszukiwania
   /// </summary>
   protected void btnSearch_Click(object sender, EventArgs e)
   {
      // Przekierowanie jest wykonywane tylko gdy udao si sprawdzenie grupy poprawnoci
      if (IsValid)
      {
         Response.Redirect("Search.aspx?search=" + txtSearch.Text);
      }
   }
   /// <summary>
   /// Procedura obsugi przycisku recenzji ksiki
   /// </summary>
   protected void btnSubmit_Click(object sender, EventArgs e)
   {
     // wykonanie przekierowania, jeeli udao si sprawdzenie grupy poprawnoci
      if (IsValid)
      {
         Response.Redirect("ProcessForm.aspx");
      }
   }
   /// <summary>
   /// Obsuga wasnej kontrolki sprawdzajcej poprawno
   /// </summary>
   protected void custDate_ServerValidate(object source, ServerValidateEventArgs args)
   {
      // prba konwersji danych uytkownika na dat
      string sEnteredDate = args.Value;
      DateTime dt;
      bool convertSuccessful = DateTime.TryParse(sEnteredDate, out dt);
      // jeeli konwersja udaa si, sprawdzenie, czy data jest z przyszoci
      if (convertSuccessful && dt >= DateTime.Today)
         args.IsValid = true;
      else
         args.IsValid = false;
   }
}
