using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{

   /// <summary>
   /// Data access object for customer cards
   /// </summary>
   public class CustomerCardDAO : AbstractDAO<CustomerCard>
   {
      public CustomerCardDAO()
      {
      }

      protected override string SelectStatement
      {
         get { return "SELECT CardNumber,CardType,CardName,ExpDate,CreditLimit,Balance,Holds,IsCancelled FROM CustomerCards"; }
      }
      protected override string PrimaryKeyName
      {
         get { return "CardNumber"; }
      }
      public override bool IsGetAllCached
      {
         get { return true; }
      }
      public override string CacheName
      {
         get { return "CustomerCards"; }
      }

      protected override CustomerCard CreateAndFillEntity(DbDataReader recordJustRead)
      {
         // grab the record values and put them into temporary variables
         string cardNumber = recordJustRead.GetString(0);
         string cardName = recordJustRead.GetString(1);
         string sCardType = recordJustRead.GetString(2);
         CustomerCardTypes cardType = ConvertStringToCardType(sCardType);
         DateTime expDate = recordJustRead.GetDateTime(3);
         decimal creditLimit = recordJustRead.GetDecimal(4);
         decimal balance = recordJustRead.GetDecimal(5);
         decimal holds = recordJustRead.GetDecimal(6);
         bool isCancelled = recordJustRead.GetBoolean(7);

         // build and populate object from the data
         CustomerCard card = new CustomerCard(cardNumber, cardName, cardType, expDate,
            creditLimit, balance, holds, isCancelled);
         return card;
      }

      private CustomerCardTypes ConvertStringToCardType(string sType)
      {
         if (sType == "MAST")
            return CustomerCardTypes.Mastercard;
         else if (sType == "VISA")
            return CustomerCardTypes.Visa;
         else if (sType == "AMEX")
            return CustomerCardTypes.AmericanExpress;
         else
            return CustomerCardTypes.Discovery;
      }

      public override DataTable AdaptCollectionToDataTable(EntityCollection<CustomerCard> collection)
      {
         DataTable dt = new DataTable();
         dt.Columns.Add(new DataColumn("CardType", Type.GetType("System.String")));
         dt.Columns.Add(new DataColumn("CardName", Type.GetType("System.String")));

         foreach (CustomerCard cc in collection)
         {
            DataRow dr = dt.NewRow();
            dr[0] = cc.CardNumber;
            dr[1] = cc.CardName;
            dt.Rows.Add(dr);
         }
         return dt;
      }

      public override void Update(CustomerCard card)
      {
         // to do
      }
      public void UpdateBalanceHold(CustomerCard card)
      {
         string sql = "UPDATE CustomerCards SET Balance=@Balance,Holds=@Holds";
         sql += " WHERE CardNumber=@CardNumber";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@CardNumber", card.CardNumber, DbType.String),
            DatabaseActions.MakeParameter("@Balance", card.Balance, DbType.Decimal),
            DatabaseActions.MakeParameter("@Holds", card.Holds, DbType.Decimal)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Insert(CustomerCard card)
      {
         // to do
      }

      public override void Delete(CustomerCard card)
      {
         // to do
      }
   }
}