using System;
using System.Data;

namespace FourLayer.BusinessEntity
{

   /// <summary>
   /// Encapsulates the data for a single book
   /// </summary>
   [Serializable]
   public class Book : AbstractEntity
   {
      // data members
      private string _title = "";
      private Publisher _publisher = null;
      private Series _series = null;
      private Category _category = null;      
      private int _yearPublished = 0;
      private string _briefDescription = "";
      private EntityCollection<Author> _authors;

      public Book() { }
      public Book(string isbn, string title, Publisher publisher, Series series, Category category, int yearPublished, string briefDescription)
         : base(isbn)
      {
         _title = title;
         _publisher = publisher;
         _series = series;
         _category = category;
         _yearPublished = yearPublished;
         _briefDescription = briefDescription;
         _authors = new EntityCollection<Author>();
      }

      public void AddAuthor(Author a)
      {
         if (a != null)
         {
            if (a.IsValid)
               _authors.Add(a);
         }
      }
      public void RemoveAuthor(Author a)
      {
         if (a != null)
         {
            _authors.Remove(a);
         }
      }

      
      public string Isbn
      {
         get { return (string)Key; }
         set { Key = value; }
      }
      public string Title
      {
         get { return _title; }
         set { _title = value; }
      }
      public Publisher BookPublisher
      {
         get {
            if (_publisher == null)
               _publisher = new Publisher();
            return _publisher; 
         }
         set { _publisher = value; }
      }
      public int PublisherId
      {
         get { return BookPublisher.Id; }
         set { BookPublisher.Id = value; 
         }
      }
      public Series BookSeries
      {
         get {
            if (_series == null)
               _series = new Series();
            return _series; 
         }
         set { _series = value; }
      }
      public int SeriesId
      {
         get { return BookSeries.Id; }
         set { BookSeries.Id = value; }
      }
      public Category BookCategory
      {
         get {
            if (_category == null)
               _category = new Category();
            return _category; 
         }
         set { _category = value; }
      }
      public int CategoryId
      {
         get { return BookCategory.Id; }
         set { BookCategory.Id = value; }
      }
      public int YearPublished
      {
         get { return _yearPublished; }
         set { _yearPublished = value; }
      }
      public string BriefDescription
      {
         get { return _briefDescription; }
         set { _briefDescription = value; }
      }
      public EntityCollection<Author> Authors
      {
         get { return _authors; }
      }


      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            bool flag = true;
            if (Isbn == null)
            {
               AddBrokenRule("Book ISBN cannot be null");
               flag = false;
            }
            else if (Isbn.Length < 0)
            {
               AddBrokenRule("Book ISBN cannot be empty");
               flag = false;
            }

            if (Title == null)
            {
               AddBrokenRule("Book title cannot be null");
               flag = false;
            }
            else if (Title.Length < 0)
            {
               AddBrokenRule("Book title cannot be empty");
               flag = false;
            }

            if (BookPublisher == null)
            {
               AddBrokenRule("Book publisher cannot be null");
               flag = false;
            }
            if (BookSeries == null)
            {
               AddBrokenRule("Book series cannot be null");
               flag = false;
            }
            if (BookCategory == null)
            {
               AddBrokenRule("Book category cannot be null");
               flag = false;
            }

            if (YearPublished < 1980)
            {
               AddBrokenRule("Book year published cannot be prior to 1980");
               flag = false;
            }
            return flag;
         }
      }

      public override string ToString()
      {
         return Isbn + "," + Title;
      }
   }
}