using System;
using System.Data;
using System.Collections.Generic;
using System.Web;


using FourLayer.BusinessEntity;
using FourLayer.DataAccessObject;

namespace FourLayer.ApplicationLogic
{

   /// <summary>
   /// Handles all the application logic for catalog
   /// </summary>
   public class BookCatalogLogic
   {
      /*
      * Books
      */


      public EntityCollection<Author> GetBookAuthors(string isbn)
      {         
         Book b = GetBookByIsbn(isbn);
         return b.Authors;
      }
      public void UpdateBook(Book book)
      {
         if (book.IsValid)
         {
            BookDAO dao = new BookDAO();
            dao.Update(book);
         }
      }
      public void InsertBook(Book book)
      {
         BookDAO dao = new BookDAO();
         dao.Insert(book);
      }
      public void DeleteBook(Book book)
      {
         BookDAO dao = new BookDAO();
         dao.Delete(book);
      }
      public Book GetBookByIsbn(string isbn)
      {
         if (isbn == null)
            return null;

         Book b = (Book)HttpContext.Current.Cache[isbn];
         if (b == null)
         {
            BookDAO dao = new BookDAO();
            b = dao.GetByKey(isbn);
            HttpContext.Current.Cache[isbn] = b;
         }
         return b;
      }
      public EntityCollection<Book> GetAllBooks()
      {
         BookDAO dao = new BookDAO();
         return dao.GetAll();
      }
      public EntityCollection<Book> GetBooksByPublisher(int pubId)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("Books.PublisherId", "=", pubId);
      }
      public EntityCollection<Book> GetBooksByPublisher(string pubName)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("PublisherName", "=", pubName);
      }
      public EntityCollection<Book> GetBooksByCategory(int catId)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("Books.CategoryId", "=", catId);
      }
      public EntityCollection<Book> GetBooksBySeries(int seriesId)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("Books.SeriesId", "=", seriesId);
      }


      /*
       * Publishers
       */
     
      public EntityCollection<Publisher> GetAllPublishers()
      {
         PublisherDAO dao = new PublisherDAO();
         return dao.GetAll();
      }
      public DataTable GetAllPublishersAsDataTable()
      {
         PublisherDAO dao = new PublisherDAO();
         EntityCollection<Publisher> collection = dao.GetAll();
         return dao.AdaptCollectionToDataTable(collection);
      }
      public void UpdatePublisher(Publisher publisher)
      {
         PublisherDAO dao = new PublisherDAO();
         dao.Update(publisher);
      }
      public void InsertPublisher(Publisher publisher)
      {
         PublisherDAO dao = new PublisherDAO();
         dao.Insert(publisher);
      }
      public void DeletePublisher(Publisher publisher)
      {
         PublisherDAO dao = new PublisherDAO();
         dao.Delete(publisher);
      }
      public Publisher GetPublisherById(int id)
      {
         PublisherDAO dao = new PublisherDAO();
         return dao.GetByKey(id);
      }


      /*
       * Series
       */
      public EntityCollection<Series> GetAllSeries()
      {
         SeriesDAO dao = new SeriesDAO();
         return dao.GetAll();
      }
      public void UpdateSeries(Series series)
      {
         SeriesDAO dao = new SeriesDAO();
         dao.Update(series);
      }
      public void InsertSeries(Series series)
      {
         SeriesDAO dao = new SeriesDAO();
         dao.Insert(series);
      }
      public void DeleteSeries(Series series)
      {
         SeriesDAO dao = new SeriesDAO();
         dao.Delete(series);
      }
      public Series GetSeriesById(int id)
      {
         SeriesDAO dao = new SeriesDAO();
         return dao.GetByKey(id);
      }

      /*
       * Category
       */
      public EntityCollection<Category> GetAllCategories()
      {
         CategoryDAO dao = new CategoryDAO();
         return dao.GetAll();
      }
      public void UpdateCategory(Category category)
      {
         CategoryDAO dao = new CategoryDAO();
         dao.Update(category);
      }
      public void InsertCategory(Category category)
      {
         CategoryDAO dao = new CategoryDAO();
         dao.Insert(category);
      }
      public void DeleteCategory(Category category)
      {
         CategoryDAO dao = new CategoryDAO();
         dao.Delete(category);
      }
      public Category GetCategoryById(int id)
      {
         CategoryDAO dao = new CategoryDAO();
         return dao.GetByKey(id);
      }

      /*
       * Author
       */
      public EntityCollection<Author> GetAllAuthors()
      {
         AuthorDAO dao = new AuthorDAO();
         return dao.GetAll();
      }
      public void UpdateAuthor(Author author)
      {
         AuthorDAO dao = new AuthorDAO();
         dao.Update(author);
      }
      public void InsertAuthor(Author author)
      {
         AuthorDAO dao = new AuthorDAO();
         dao.Insert(author);
      }
      public void DeleteAuthor(Author author)
      {
         AuthorDAO dao = new AuthorDAO();
         dao.Delete(author);
      }
      public Author GetAuthorById(int id)
      {
         AuthorDAO dao = new AuthorDAO();
         return dao.GetByKey(id);
      }
   }
}