<%@ Page Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true" CodeFile="BookDetails.aspx.cs" Inherits="BookDetails" Title="Product Page" %>

<%@ Register Src="controls/RecentViewsControl.ascx" TagName="RecentViewsControl"
   TagPrefix="uc1" %>
   
<%@ MasterType VirtualPath="~/Site.master" %>

<asp:Content ID="Content1" ContentPlaceHolderID="sideContent" Runat="Server">
  <asp:LoginView ID="logView" runat="server">
   <LoggedInTemplate>
     <h2>Lista ycze</h2>
      <p>
      <asp:LinkButton ID="lnkWish" runat="server" Text="Dodaj do listy ycze" OnClick="lnkWish_Click" />
      </p>
   </LoggedInTemplate>
   <AnonymousTemplate>
      <asp:LoginStatus ID="logStatus" runat="server" />
   </AnonymousTemplate>
  </asp:LoginView>
  <hr /> 
  <uc1:RecentViewsControl ID="myRecents" runat="server" />

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="mainContent" Runat="Server">

   <asp:DetailsView ID="detvBooks" runat="server" DataSourceID="dsBooks" AutoGenerateRows="false" >
      <Fields>
         <asp:TemplateField>
            <ItemTemplate>
               <h1><%# Eval("Title") %></h1>
            </ItemTemplate>
         </asp:TemplateField>            
         <asp:ImageField ShowHeader="false" DataImageUrlField="Isbn" DataImageUrlFormatString="images/{0}.gif"
            DataAlternateTextField="Title" DataAlternateTextFormatString="Okadka {0}" />
         <asp:TemplateField>
            <ItemTemplate>              
              <p>
                <b>ISBN: </b><%# Eval("ISBN") %><br />
                <b>Wydawca: </b><%# Eval("PublisherName") %> (<%# Eval("YearPublished") %>)
              </p>
              <p>
               <%# Eval("BriefDescription") %> 
              </p>
            </ItemTemplate>
         </asp:TemplateField>
      </Fields>
   </asp:DetailsView>
         
      <asp:SqlDataSource ID="dsBooks" runat="server"
	       ProviderName="System.Data.SqlClient" 
	       ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
	       SelectCommand="SELECT ISBN,Title,PublisherName,Books.PublisherId,YearPublished,BriefDescription FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId WHERE ISBN=@isbn">

         <SelectParameters>
            <asp:QueryStringParameter Name="isbn" QueryStringField="id" />
         </SelectParameters>			 
      	 
      </asp:SqlDataSource>         
</asp:Content>

