using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

namespace Chapter14
{
   /// <summary>
   /// Skadnik web part dostawcy
   /// </summary>
   public class SelectPublisherProvider : WebPart, ISelectPublisher
   {
      DropDownList _drpPublishers;

      public SelectPublisherProvider()
      {
         Title = "Wybierz wydawc";
         Description = "Wybierz dostawc w celu przetestowania pocze";
         TitleIconImageUrl = "images/webpartBooks.gif";
         CatalogIconImageUrl = "images/webpartBooks.gif"; 
      }

      /// <summary>
      /// Implementacja metody zdefiniowanej w klasie ISelectPublisher
      /// </summary>
      public Publisher ChosenPublisher
      {
         get { 
            // zwr obiekt wydawcy dla wybranego identyfikatora
            int pubId = Convert.ToInt32(_drpPublishers.SelectedValue);
            return BookCatalogLogic.GetPublisherById(pubId);
         }
      }

      /// <summary>
      /// Definiuje punkt poczenia
      /// </summary>
      [ConnectionProvider("SelectedPublisherConnectionPoint")]
      public ISelectPublisher SupplyProvider()
      {
         return this;
      }

      protected override void CreateChildControls()
      {
         _drpPublishers = new DropDownList();
         _drpPublishers.AutoPostBack = true;

         // get all the publishers 
         EntityCollection<Publisher> pubs = BookCatalogLogic.GetAllPublishers();

         _drpPublishers.DataTextField = "Name";
         _drpPublishers.DataValueField = "Id";

         _drpPublishers.DataSource = pubs;
         _drpPublishers.DataBind();

         Literal lit = new Literal();
         lit.Text = "Choose a publisher: ";

         Controls.Add(lit);
         Controls.Add(_drpPublishers);
      }
   }
}
