using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using System.Xml;
using System.Xml.XPath;
using System.Xml.Xsl;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

namespace Chapter14
{
   public class PublisherRSSConsumer : WebPart
   {
      private string _xsltUrl = "~/RssTransformPressRelease.xsl";
      private ISelectPublisher _pubInterface;

      public PublisherRSSConsumer()
      {
         Title = "Nowoci";
         Description = "Nowoci wydawcy";
         TitleIconImageUrl = "images/webpartNews.gif";
         CatalogIconImageUrl = "images/webpartNews.gif";
      }

      [Personalizable(PersonalizationScope.Shared),
        WebBrowsable, WebDisplayName("XSLT filename")]
      public string XsltUrl
      {
         get { return _xsltUrl; }
         set { _xsltUrl = value; }
      }


      /// <summary>
      /// odpowiada za tworzenie zawartoci kontrolki
      /// </summary>
      protected override void CreateChildControls()
      {
         // utwrz kontrolk xml serwera web
         Xml myXml = new Xml();

         // skonfiguruj kontrolk XML, uywajc dostawcy wyboru wydawcy
         if (_pubInterface != null)
         {
            // pobierz wydawc od dostawcy
            Publisher p = _pubInterface.ChosenPublisher;
            if (p != null)
            {
               Title = "Nowoci wydawcy " + p.Name;

               // uyj adresu url kanau RSS zdefiniowanego dla wydawcy
               XPathDocument xpdoc = new XPathDocument(p.RssUrl);
               // skonfiguruj nawigatora cieki dla danego dokumentu xml
               XPathNavigator xnav = xpdoc.CreateNavigator();
               myXml.XPathNavigator = xnav;
               // okrel plik xslt
               myXml.TransformSource = HttpContext.Current.Server.MapPath(XsltUrl);
            }
         }

         // dodaj kontrolk xml do zbioru kontrolek potomnych skadnika web part
         Controls.Add(myXml);
      }

      [ConnectionConsumer("SelectedPublisherConnectionPoint")]
      public void GetProvider(ISelectPublisher pubInterface)
      {
         _pubInterface = pubInterface;
      }
   }
}
