using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using System.Xml;
using System.Xml.XPath;
using System.Xml.Xsl;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

namespace Chapter14
{
   /// <summary>
   /// rne aspekty kanaw RSS z komunikatami prasowymi
   /// </summary>
   public enum PressReleaseRssFeeds
   {
      AddisonWesley, PeachPit, PrenticeHall, QuePublishing, SamsPublishing
   }

   public class PressReleaseRSS: WebPart 
   {
      private string _xsltUrl = "~/RssTransformPressRelease.xsl";
      private PressReleaseRssFeeds _whichFeed = PressReleaseRssFeeds.AddisonWesley;

      // w tym miejscu adresy URL kanaw RSS zostan umieszczone w kodzie programu,
      // jednak lepszym i bardziej realistycznym rozwizaniem bdzie
      // pobranie ich z bazy danych lub pliku konfiguracyjnego
      private string[] _rssUrls = {
         "http://www.awprofessional.com/press/press_rss.asp",
         "http://www.peachpit.com/press/press_rss.asp",
         "http://www.phptr.com/press/press_rss.asp",
         "http://www.quepublishing.com/press/press_rss.asp",
         "http://www.samspublishing.com/press/press_rss.asp"      
      };

      public PressReleaseRSS()
      {
         Title = "Komunikaty prasowe";
         Description = "Komunikaty prasowe wydawnictwa Pearson Ed";
         TitleIconImageUrl = "images/webpartNews.gif";
         CatalogIconImageUrl = "images/webpartNews.gif";
      }

      [Personalizable(PersonalizationScope.Shared),
        WebBrowsable, WebDisplayName("XSLT filename")]
      public string XsltUrl
      {
         get { return _xsltUrl; }
         set { _xsltUrl = value; }
      }

      [Personalizable(PersonalizationScope.User),
     WebBrowsable, WebDisplayName("Kana RSS z komunikatami prasowymi")]
      public PressReleaseRssFeeds WhichFeed
      {
         get { return _whichFeed; }
         set { _whichFeed = value; }
      }

      /// <summary>
      /// Odpowiada za tworzenie zawartoci kontrolki
      /// </summary>
      protected override void CreateChildControls()
      {
         // utwrz kontrolk xml serwera web
         Xml myXml = new Xml();

         // pobierz adres URL wybranego kanau
         string xmlurl = _rssUrls[(int)WhichFeed];

         // utwrz obiekt klasy XPathNavigator
         XPathDocument xpdoc = new XPathDocument(xmlurl);
         XPathNavigator xnav = xpdoc.CreateNavigator();

         // skonfiguruj kontrolk xml i zastosuj transformacj xslt
         myXml.XPathNavigator = xnav;
         myXml.TransformSource = HttpContext.Current.Server.MapPath(XsltUrl);

         // dodaj kontrolk xml do zbioru kontrolek potomnych skadnika web part
         Controls.Add(myXml);
      }

   }
}
