using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Profile;
using System.IO;

/// <summary>
/// Oglny opis CustomProfile
/// </summary>
public class CustomProfile: ProfileBase 
{
   [SettingsAllowAnonymous(false)]
   public List<WishListItem> WishList
   {
      get { 
         if (base["WishList"] == null)
            base["WishList"] = new List<WishListItem>();
         return (List<WishListItem>)base["WishList"]; 
      }
      set { base["WishList"] = value; }
   }

   [SettingsAllowAnonymous(true)]
   public string Theme
   {
      get {
         string theme = (string)base["Theme"];
         // set up a default theme if necessary
         if (theme.Length == 0)
         {
            theme = "Cool";
            base["Theme"] = theme;
         }
         return theme; 
      }
      set
      {
         string newThemeName = value;

         string path = HttpContext.Current.Server.MapPath("~/App_Themes");
         if (Directory.Exists(path))
         {
            // pobierz tablic z nazwami folderw z motywami
            String[] themeFolders = Directory.GetDirectories(path);
            bool found = false;
            // sprawd, czy podana nazwa motywu rzeczywicie istnieje w folderze z motywami
            foreach (String folder in themeFolders)
            {
               DirectoryInfo info = new DirectoryInfo(folder);
               if (info.Name == newThemeName)
                  found = true;
            }
            // ustaw motyw tylko wtedy, gdy dany motyw istnieje
            if (found)
               base["Theme"] = newThemeName;
         }
      }
   }

   [SettingsAllowAnonymous(true)]
   public ViewedProducts Last5Products
   {
      get {
         if (base["Last5Products"] == null)
            base["Last5Products"] = new ViewedProducts();
         return (ViewedProducts)base["Last5Products"]; 
      }
      set { base["Last5Products"] = value;  }
   }

   [SettingsAllowAnonymous(false)]
   public bool MigratedAlready
   {
      get { return (bool)base["MigratedAlready"]; }
      set { base["MigratedAlready"] = value; }
   }
}
