using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ThreeLayer.Business;

public partial class TestBusinessObject : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
       if (!IsPostBack)
       {
          panPublisher.Visible = false;
       }

       PublisherCollectionBO pubs = new PublisherCollectionBO();

       grdPublishers.DataSource = pubs.ReadOnlyCopy();
       grdPublishers.DataBind();

    }
   protected void grdPublishers_SelectedIndexChanged(object sender, EventArgs e)
   {
      int pubId = (int)grdPublishers.SelectedDataKey.Values[0];

      PublisherBO pub = new PublisherBO();
      if (pub.Load(pubId))
      {
         panPublisher.Visible = true;
         labId.Text = pub.Id.ToString();
         txtName.Text = pub.Name;
      }
      grdErrors.DataSource = pub.BrokenRules;
      grdErrors.DataBind();
   }

   protected void btnUpdate_Click(object sender, EventArgs e)
   {
      // pobierz wartoci identyfikatora i tytuu
      int id = Convert.ToInt32(labId.Text);
      string name = txtName.Text;
      // utwrz obiekt biznesowy wydawcy i sprbuj go zaktualizowa
      PublisherBO pub = new PublisherBO(id, name);
      pub.Update();
      // sprawd, czy aktualizacja powidoa si
      if (!pub.IsValid)
      {
         // aktualizacja nie powioda si, a zatem wywietl naruszone reguy biznesowe
         grdErrors.DataSource = pub.BrokenRules;
         grdErrors.DataBind();
      }
      grdPublishers.DataBind();
   }

   protected void btnInsert_Click(object sender, EventArgs e)
   {
      // pobierz warto tytuu
      string name = txtName.Text;
      PublisherBO pub = new PublisherBO(0, name);
      pub.Insert();
      if (!pub.IsValid)
      {
         grdErrors.DataSource = pub.BrokenRules;
         grdErrors.DataBind();
      }
   }
}
