using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;
using System.Collections.ObjectModel;

using TwoLayer.DataAccess;

namespace ThreeLayer.Business
{
   /// <summary>
   /// Oglny opis BookCollectionBO
   /// </summary>
   public class BookCollectionBO
   {
      private List<BookBO> _list;

      public BookCollectionBO()
      {
         _list = new List<BookBO>();
         Load();
      }

      public void Add(BookBO book)
      {
         if (book != null)
            _list.Add(book);
      }

      public BookBO Get(string isbn)
      {
         foreach (BookBO book in _list)
         {
            if (book.Isbn == isbn)
               return book;
         }
         return null;
      }

      public void Load()
      {
         BookDA da = new BookDA();
         DataTable dt = da.GetAll();

         foreach (DataRow dr in dt.Rows)
         {
            string isbn = (string)dr["Isbn"];
            string title = (string)dr["Title"];

            int pubId = (int)dr["PublisherId"];
            string pubName = (string)dr["PublisherName"];
            PublisherBO pub = new PublisherBO(pubId, pubName);

            int pubYear = (int)dr["YearPublished"];

            BookBO book = new BookBO(isbn, title, pub, pubYear);
            Add(book);
         }
      }

      public ReadOnlyCollection<BookBO> ReadOnlyCopy()
      {
         return _list.AsReadOnly();
      }

   }
}