using System;
using System.Data;

using TwoLayer.DataAccess;

namespace ThreeLayer.Business
{
   /// <summary>
   /// oglny opis BookBO
   /// </summary>
   public class BookBO : AbstractBO
   {
      private string _isbn = "";
      private PublisherBO _publisher = null;
      private string _title = "";
      private int _yearPublished = 0;


      
      public BookBO()
      {
      }
      public BookBO(string isbn, string title, PublisherBO publisher, int yearPublished)
      {
         _isbn = isbn;
         _title = title;
         _publisher = publisher;
         _yearPublished = yearPublished;
      }

      public bool Load(string isbn)
      {
         BookDA da = new BookDA();
         DataTable table = da.GetById(isbn);
         if (table.Rows.Count == 0)
            return false;

         Isbn = (string)table.Rows[0]["Isbn"];
         Title = (string)table.Rows[0]["PublisherName"];
         YearPublished = (int)table.Rows[0]["YearPublished"];
         Publisher = new PublisherBO((int)table.Rows[0]["PublisherId"], (string)table.Rows[0]["PublisherName"]);

         return true;
      }

      public void Save()
      {
         BookDA da = new BookDA();
        /*
         if (IsNew)
            da.InsertBook(Title,Publisher);
         else if (IsModified)
            da.UpdateBook(Isbn, Title, Publisher);
        */
      }
      /// <summary>
      /// Tylko aktualizuje dane
      /// </summary>
      public void Update()
      {
         BookDA da = new BookDA();
         /*
         if (IsModified)
            da.UpdatePublisher(Id, Name);
          * */
      }

      /// <summary>
      /// Usuwa dane
      /// </summary>
      public void Delete()
      {
         BookDA da = new BookDA();
         
         //da.DeleteBook(Id);
      }

      /// <summary>
      /// Sprawdza, czy wewntrzny stan obiektu biznesowego jest prawidowy
      /// </summary>
      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            bool valid = true;
            if (Isbn.Length == 0)
            {
               AddBrokenRule("Numer ISBN nie moe byc pusty");
               valid = false;
            }
            if (Title.Length == 0)
            {
               AddBrokenRule("Tytu nie moe by pusty");
               valid = false;
            }
            return valid;
         }
      }



      public string Isbn
      {
         get { return _isbn; }
         set { _isbn = value; }
      }

      public string Title
      {
         get { return _title; }
         set { _title = value; }
      }

      public PublisherBO Publisher
      {
         get { return _publisher; }
         set { _publisher = value; }
      }
      public int YearPublished
      {
         get { return _yearPublished; }
         set { _yearPublished = value; }
      }
   }
}
