using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{

   /// <summary>
   /// oglny opis PublisherDAO
   /// </summary>
   public class PublisherDAO: AbstractDAO<Publisher> 
   {
      public PublisherDAO()
      {
      }

      protected override string SelectStatement
      {
         get { return "SELECT PublisherId, PublisherName FROM Publishers"; }
      }
      protected override string PrimaryKeyName
      {
         get { return "PublisherId"; }
      }
      public override bool IsGetAllCached
      {
         get { return true; }
      }
      public override string CacheName
      {
         get { return "Publishers"; }
      }

      protected override Publisher CreateAndFillEntity(DbDataReader recordJustRead)
      {
         /// pobierz wartoci rekordw i umie je w zmiennych tymczasowych
         //int id = recordJustRead.GetInt32(0);
         //string name = recordJustRead.GetString(1);

         int id = (int)recordJustRead["PublisherId"];
         string name = (string)recordJustRead["PublisherName"];

         // utwrz i wypenij obiekt na podstawie danych
         Publisher pub = new Publisher(id, name);
         return pub;
      }

      public override DataTable AdaptCollectionToDataTable(EntityCollection<Publisher> collection)
      {
         DataTable dt = new DataTable();
         dt.Columns.Add(new DataColumn("Id", Type.GetType("System.Int32")));
         dt.Columns.Add(new DataColumn("Name", Type.GetType("System.String")));

         foreach (Publisher p in collection)
         {
            DataRow dr = dt.NewRow();
            dr[0] = p.Id;
            dr[1] = p.Name;
            dt.Rows.Add(dr);
         }
         return dt;
      }

      public override void Update(Publisher publisher)
      {
         string sql = "UPDATE Publishers SET PublisherName=@PublisherName";
         sql += " WHERE PublisherId=@PublisherId";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@PublisherId", publisher.Id, DbType.Int32),
            DatabaseActions.MakeParameter("@PublisherName", publisher.Name, DbType.String)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Insert(Publisher publisher)
      {
         string sql = "INSERT INTO Publishers (PublisherName) ";
         sql += " VALUES (@PublisherName)";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@PublisherName", publisher.Name, DbType.String)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Delete(Publisher publisher)
      {
         string sql = "DELETE FROM Publishers WHERE PublisherId=@PublisherId";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@PublisherId", publisher.Id, DbType.Int32)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }
   }
}