using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

public partial class TestApplicationLogic : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
   protected void dsBookCatPublisher_Updating(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckPublisher(e);
   }
   protected void dsBookCatPublisher_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckPublisher(e);
   }
   private void CheckPublisher(ObjectDataSourceMethodEventArgs e)
   {
      Publisher p = (Publisher)e.InputParameters[0];
      if (!p.IsValid)
      {
         e.Cancel = true;
         grdErrorsPublishers.DataSource = p.BrokenRules;
         grdErrorsPublishers.DataBind();
      }     
   }


   protected void dsBookCatSeries_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckSeries(e);
   }
   protected void dsBookCatSeries_Updating(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckSeries(e);
   }
   private void CheckSeries(ObjectDataSourceMethodEventArgs e)
   {
      Series s = (Series)e.InputParameters[0];
      if (!s.IsValid)
      {
         e.Cancel = true;
         grdErrorsSeries.DataSource = s.BrokenRules;
         grdErrorsSeries.DataBind();
      }
   }


   protected void dsBookCatCategories_Updating(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckCategory(e);
   }
   protected void dsBookCatCategories_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckCategory(e);
   }
   private void CheckCategory(ObjectDataSourceMethodEventArgs e)
   {
      Category c = (Category)e.InputParameters[0];
      if (!c.IsValid)
      {
         e.Cancel = true;
         grdErrorsCategories.DataSource = c.BrokenRules;
         grdErrorsCategories.DataBind();
      }
   }


   protected void dsBookCatAuthors_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckAuthor(e);
   }
   protected void dsBookCatAuthors_Updating(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckAuthor(e);
   }
   private void CheckAuthor(ObjectDataSourceMethodEventArgs e)
   {
      Author a = (Author)e.InputParameters[0];
      if (!a.IsValid)
      {
         e.Cancel = true;
         grdErrorsAuthors.DataSource = a.BrokenRules;
         grdErrorsAuthors.DataBind();
      }
   }


   protected void dsBookCatBook_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckBook(e);
   }
   protected void dsBookCatBook_Updating(object sender, ObjectDataSourceMethodEventArgs e)
   {
      CheckBook(e);
   }
   private void CheckBook(ObjectDataSourceMethodEventArgs e)
   {
      Book b = (Book)e.InputParameters[0];
      if (!b.IsValid)
      {
         e.Cancel = true;
         grdErrorsBooks.DataSource = b.BrokenRules;
         grdErrorsBooks.DataBind();
      }
   }

}
