<%@ Page Language="C#" AutoEventWireup="true" CodeFile="BookPortal.aspx.cs" Inherits="BookPortal" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
	<title>Portal ksigarski</title>
	<link href="chapterStyles.css" type="text/css" rel="stylesheet" />
	<style type="text/css">
		.dataValues { font-weight: bold; }
		.singleBook { border-top: 1pt solid #E7E7E7;
		              border-left: 1pt solid #E7E7E7;
		              border-bottom: 1pt solid #D2D2D2;
		              border-right: 1pt solid #D2D2D2;
		              padding: 1em;	
		              margin: 1em;              
		              background: #FFFFE0;		              
		               }
		 .singleBookTitle {
                    vertical-align: middle;
                    text-align: center;
		              background: #FFFFCC;
		              }
		  .entireForm {
		            border: 2pt solid #D7D7D7; 
		  }
		  body { margin: 7px; }
		  .box { margin: 5px 0 10px 0; padding: 5px; border: 1pt solid silver; width: 171px;}
		  #header { margin: 0 0 2px 0; background-color: #FFFBD6; padding: 10px; border: 1pt solid silver;}
		  #leftSide {margin: 0; float: left; }
		  #rightSide {margin: 0; float: right; position: relative; top: -8px; }
		  .largeBox { margin: 10px 0; padding: 5px; border: 1pt solid silver; }
	</style>
</head>
<body>
	<form id="form1" runat="server">
		<div id="header">
			<h1>Portal ksigarski</h1>
			<div style="float:right; position: relative; top: -15px;">
		      <a href="BookPortal.aspx">Poka wszystkie ksiki</a>
		   </div>  
      </div>
		<div id="leftSide">
         <div class="box">       
            <asp:GridView ID="grdPublisher" runat="server" 
               DataSourceID="dsPublishers" DataKeyNames="Id"
               GridLines="None" Width="170"
               AutoGenerateColumns="False" CellPadding="4" ForeColor="#333333" 
               OnSelectedIndexChanged="grdPublisher_SelectedIndexChanged">
               <Columns>
                  <asp:TemplateField HeaderText="Wydawcy">
                     <ItemTemplate>
                        <asp:LinkButton ID="btnSelectPublisher" runat="server"
                            Text='<%# Eval("Name") %>'  
                           CommandName="Select" />
                     </ItemTemplate>
                  </asp:TemplateField>                       
               </Columns>               
               <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
               <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
               <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White" HorizontalAlign="Left"/>
               <AlternatingRowStyle BackColor="White" />
            </asp:GridView>
         </div>  
         		
         <div class="box">
            <asp:GridView ID="grdSeries" runat="server" GridLines="None"
               DataSourceID="dsSeries" AutoGenerateColumns="False" 
               DataKeyNames="Id" Width="170"
               OnSelectedIndexChanged="grdSeries_SelectedIndexChanged" CellPadding="4" ForeColor="#333333">
               <Columns>
                  <asp:TemplateField HeaderText="Serie">
                     <ItemTemplate>
                        <asp:LinkButton ID="btnSelectSeries" runat="server"
                            Text='<%# Eval("Name") %>'  
                           CommandName="Select" />
                     </ItemTemplate>
                  </asp:TemplateField>                       
               </Columns>
               <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
               <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
               <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White" HorizontalAlign="Left"/>
               <AlternatingRowStyle BackColor="White" />
            </asp:GridView>
         </div>

         <div class="box">         
            <asp:GridView ID="grdCategories" runat="server" GridLines="None"
               DataKeyNames="Id" DataSourceID="dsCategories" Width="170"
               AutoGenerateColumns="False" CellPadding="4" ForeColor="#333333" 
               OnSelectedIndexChanged="grdCategory_SelectedIndexChanged">
               <Columns>
                  <asp:TemplateField HeaderText="Kategorie">
                     <ItemTemplate>
                        <asp:LinkButton ID="btnSelectCategory" runat="server"
                            Text='<%# Eval("Name") %>'  
                           CommandName="Select" />
                     </ItemTemplate>
                  </asp:TemplateField>                       
               </Columns>
               <FooterStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
               <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
               <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
               <PagerStyle BackColor="#FFCC66" ForeColor="#333333" HorizontalAlign="Center" />
               <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White" HorizontalAlign="Left"/>
               <AlternatingRowStyle BackColor="White" />
            </asp:GridView>
         </div>               
      </div>
      
      <div id="rightSide">  
         <div class="largeBox">                   
            <asp:GridView ID="grdBooks" runat="server" GridLines="None" Width="500"
               DataSourceID="dsBooks" DataKeyNames="Isbn"
               EmptyDataText="Nie znaleziono ksiek"
               AutoGenerateColumns="False" CellPadding="4" ForeColor="#333333">
               <Columns>
                  <asp:CommandField SelectImageUrl="images/btn_select.gif" 
                     ButtonType="Image" ShowSelectButton="true" />
                  <asp:BoundField DataField="Isbn" HeaderText="ISBN" SortExpression="Isbn" />
                  <asp:BoundField DataField="Title" HeaderText="Tytu" SortExpression="Title">
                     <ControlStyle Width="300px" />
                  </asp:BoundField>
                  <asp:BoundField DataField="YearPublished" HeaderText="Rok" SortExpression="YearPublished"/>                      
               </Columns>
               <FooterStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
               <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
               <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
               <PagerStyle BackColor="#FFCC66" ForeColor="#333333" HorizontalAlign="Center" />
               <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
               <AlternatingRowStyle BackColor="White" />
            </asp:GridView>
         </div>
         <div class="largeBox">
         <asp:DetailsView ID="dvEditBook" runat="server"
            DataSourceID="dsBookSingle" DataKeyNames="Isbn"  Width="500"
            AutoGenerateRows="False" CellPadding="4" ForeColor="#333333" GridLines="None"  >
            <HeaderTemplate >
               Informacje o ksice
            </HeaderTemplate>
            <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White"/>
            <Fields>
               <asp:BoundField DataField="Isbn" HeaderText="Isbn" ReadOnly="true"/>
                                   
               <asp:TemplateField HeaderText="Tytu">
                  <ItemTemplate>
                     <%# Eval("Title")%>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:TextBox ID="txtTitle" runat="server" Columns="55"
                       Text='<%# Bind("Title") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>      
               
               <asp:TemplateField HeaderText="Autorzy">
                  <ItemTemplate>
                     <asp:GridView id="grdAuthors" runat="server" 
                        AutoGenerateColumns="false" ShowHeader="false"
                        GridLines="none"
                        DataSource='<%# Bind("Authors") %>'>
                        
                        <Columns>
                           <asp:BoundField DataField="Name" />
                        </Columns>
                     
                     </asp:GridView>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <a href='EditAuthors.apx?book=<%# Eval("ISBN") %>'>
                     Edycja autorw 
                     </a>
                  </EditItemTemplate>                     
               </asp:TemplateField>              
               
               <asp:BoundField DataField="YearPublished" HeaderText="Rok" />  
               
               <asp:TemplateField HeaderText="Opis">
                  <ItemTemplate>
                     <%# Eval("BriefDescription")%>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:TextBox ID="txtBrief" runat="server" 
                       TextMode="multiLine" Columns="45"
                       Rows="7" Text='<%# Bind("BriefDescription") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>                                
                              
               <asp:TemplateField HeaderText="Wydawca">
                  <ItemTemplate>
                     <%# Eval("BookPublisher.Name") %>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:DropDownList ID="drpPublisher" runat="server" 
                       DataSourceID="dsPublishers" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("PublisherId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>                                 
               <asp:TemplateField HeaderText="Serie">
                  <ItemTemplate>
                     <%# Eval("BookSeries.Name") %>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:DropDownList ID="drpSeries" runat="server" 
                       DataSourceID="dsSeries" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("SeriesId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>

               <asp:TemplateField HeaderText="Kategoria">
                  <ItemTemplate>
                     <%# Eval("BookCategory.Name") %>
                  </ItemTemplate>
                  <EditItemTemplate>
                     <asp:DropDownList ID="drpCategory" runat="server" 
                       DataSourceID="dsCategories" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("CategoryId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>    
               <asp:CommandField ButtonType="Image" 
                  ShowEditButton="true" ShowCancelButton="true"
                  CancelImageUrl="images/btn_cancel.gif"
                  EditImageUrl="images/btn_edit.gif"
                  UpdateImageUrl="images/btn_update.gif" />                   
            </Fields>      

            <CommandRowStyle BackColor="White" Font-Bold="True" />
            <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
            <FieldHeaderStyle Font-Bold="True" VerticalAlign="Top"/>
            <AlternatingRowStyle BackColor="White" />
         </asp:DetailsView>
          <asp:GridView ID="grdErrors" runat="server" ShowHeader="false" GridLines="None" RowStyle-ForeColor="Red"/>
         </div>
      </div>
		    
		 
	<asp:ObjectDataSource ID="dsBooks" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"   />		
   <asp:ObjectDataSource ID="dsBookSingle" runat="server"
	    TypeName="FourLayer.ApplicationLogic.BookCatalogLogic" 
	    DataObjectTypeName="FourLayer.BusinessEntity.Book" 
	    SelectMethod="GetBookByIsbn"
	    UpdateMethod="UpdateBook"		 
	    OnUpdating="dsBookSingle_Updating"  >
	   <SelectParameters>
	      <asp:ControlParameter ControlID="grdBooks" Name="isbn" Type="string"
           PropertyName="SelectedDataKey.Values[0]" />
	   </SelectParameters>	 
   </asp:ObjectDataSource>		  
	<asp:ObjectDataSource ID="dsSeries" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllSeries" />
	<asp:ObjectDataSource ID="dsPublishers" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllPublishers" />		 
	<asp:ObjectDataSource ID="dsCategories" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllCategories" />	
	</form>
</body>
</html>

