using System;
using System.Data;
using System.Collections.Generic;

namespace FourLayer.BusinessEntity
{

   /// <summary>
   /// Oglny opis klasy AbstractEntity
   /// </summary>
   [Serializable]
   public abstract class AbstractEntity
   {
      // dane skadowe
      private object _key;
      // zbir opisw wszystkich naruszonych regu
      private List<string> _brokenRules = new List<string>();

      public AbstractEntity()
      {
         _key = 0;
      }
      public AbstractEntity(object key)
      {
         _key = key;
      }

      /// <summary>
      /// Kada encja musi mie klucz
      /// </summary>
      public object Key
      {
         get { return _key; }
         set { _key = value; }
      }


      /// <summary>
      /// Kada podklasa bdzie odpowiedzialna za sprawdzanie, czy 
      /// jej stan (dane skadowe) nie narusza regu biznesowych
      /// </summary>
      protected abstract bool CheckIfSubClassStateIsValid
      {
         get;
      }

      /// <summary>
      /// Podklasy musza mie moliwo dodawania opisw naruszonych regu
      /// </summary>
      protected void AddBrokenRule(string rule)
      {
         _brokenRules.Add(rule);
      }
      /// <summary>
      /// Zwr opisy naruszonych regu
      /// </summary>
      public List<string> BrokenRules
      {
         get { return _brokenRules; }
      }
      /// <summary>
      /// Czy obiekt biznesowy jest prawidowy?
      /// </summary>
      public bool IsValid
      {
         get
         {
            _brokenRules.Clear();
            return CheckIfSubClassStateIsValid;
         }
      }
   }
}