<%@ Page Language="C#" AutoEventWireup="true" CodeFile="SelectGridView.aspx.cs" Inherits="SelectGridView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Wybieranie wiersza w kontrolce GridView</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css">
      .box {
         margin: 1em 0; border: solid 1pt silver; padding: 0.5em;
      }
      
      .bookList { border: solid 1pt #DEDFDE; }
      .bookListRow { background-color: #F7F7DE; }
      .bookListSelected { background-color:#CE5D5A; font-weight: bold; color: White; }
      .bookListPager { background-color:#F7F7DE; font-weight: bold; color: Black; }
      .bookListHeader { background-color:#6B696B; font-weight: bold; color: White; }
      .bookListAlt { background-color: white; }
      
      .detail { border: solid 1pt #DEDFDE; }
      .detailLabel { font-weight: bold; }
      .detailRow { background-color: #F7F7DE; }
      .detailHeader { background-color:#6B696B; font-weight: bold; color: White; }
      .detailAlt { background-color: white; }      
   </style>
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
         <h1>Wybieranie wiersza w kontrolce GridView</h1>
         <p>
         W przykadzie pokazano, jak korzysta z funkcji 
         zaznaczania wiersza w kontrolce <code>GridView</code>.
         </p>
         <div class="box">
            <asp:GridView ID="grdBookList" runat="server" DataSourceID="dsBooks"
              AutoGenerateColumns="False"  
              AllowPaging="true" PageSize="4"
              DataKeyNames="Isbn"
              Width="600" CssClass="bookList"
              CellPadding="4" GridLines="Vertical" 
              OnSelectedIndexChanged="grdBookList_SelectedIndexChanged">

               <Columns>
                  <asp:CommandField ShowSelectButton="true" ButtonType="Image"
                     SelectImageUrl="images/btn_select.gif"/>
                  <asp:ImageField HeaderText="" DataImageUrlField="Isbn" 
                     DataImageUrlFormatString="images/{0}.gif"
                     DataAlternateTextField="Title" 
                     DataAlternateTextFormatString="Okadka {0}"
                     ReadOnly="True" />              
                  <asp:BoundField DataField="Title" HeaderText="Tytu"/>           
               </Columns>
               <RowStyle CssClass="bookListRow" />
               <SelectedRowStyle CssClass="bookListSelected" />
               <PagerStyle  CssClass="bookListPager" HorizontalAlign="Center"/>
               <PagerSettings Mode="NextPrevious" NextPageText=">" PreviousPageText="<" />
               <HeaderStyle CssClass="bookListHeader" />
               <AlternatingRowStyle CssClass="bookListAlt" />
            </asp:GridView>  
         </div> 
         
         <div class="box">
            <h2><asp:Label ID="labSelected" runat="server" /></h2>
            <asp:DetailsView ID="detvBook" runat="server" 
               DataSourceID="dsSingleBook" AutoGenerateRows="False" 
               CssClass="detail" CellPadding="4" 
               GridLines="Vertical" Width="600">
               <Fields>
                  <asp:BoundField DataField="ISBN" HeaderText="Isbn:" HeaderStyle-CssClass="detailLabel" />
                  <asp:BoundField DataField="PublisherName" HeaderText="Wydawca:" HeaderStyle-CssClass="detailLabel" />
                  <asp:BoundField DataField="YearPublished" HeaderText="Rok:" HeaderStyle-CssClass="detailLabel" />
                  <asp:BoundField DataField="BriefDescription" HeaderText="Opis:" HeaderStyle-CssClass="detailLabel" />
               </Fields>
               <RowStyle VerticalAlign="Top" CssClass="detailRow" />
               <HeaderStyle CssClass="detailHeader" />
               <AlternatingRowStyle CssClass="detailAlt" />
            </asp:DetailsView>
         </div>
                              
      </div>
		<asp:SqlDataSource ID="dsBooks" runat="server"
			 ProviderName="System.Data.SqlClient"  
			 ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
			 SelectCommand="SELECT ISBN,Title FROM Books" />
			 
      <asp:SqlDataSource ID="dsSingleBook" runat="server"
			 ProviderName="System.Data.SqlClient" 
			 ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
	       SelectCommand="SELECT ISBN,Title,PublisherName,Books.PublisherId,YearPublished,BriefDescription FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId WHERE ISBN=@isbn">

         <SelectParameters>
            <asp:ControlParameter ControlID="grdBookList" Name="isbn"
              PropertyName="SelectedDataKey.Values[0]" />
         </SelectParameters>			       	 
      </asp:SqlDataSource>			 
   </form>
</body>
</html>
