using System;
using System.Data;
using System.Data.Common;


/// <summary>
/// 
/// </summary>
public class PublisherDA: AbstractDA
{

	protected override string SelectStatement
	{
		get { return "SELECT PublisherId, PublisherName FROM Publishers"; }
	}

	/// <summary>
	/// Zwraca tabel danych zawierajc informacje o tabeli wydawcy dla danego identyfikatora.
	/// Zbir danych bdzie zawiera 0 albo 1 wiersz danych.
	/// </summary>
	public DataTable GetPublisherById(int id)
	{
		// utwrz sparametryzowan instrukcj zapytania
		string sql = SelectStatement + " WHERE PublisherId=@id";

		// utwrz tabel parametrw
                DbParameter[] parameters = new DbParameter[] {
			MakeParameter("@id", id, DbType.Int32)
															};
		// zwr wynik
		return GetDataTable(sql, parameters);			
	}

}
