using System;
using System.Data;

namespace FourLayer.BusinessEntity
{
   /// <summary>
   /// Hermetyzuje dane pojedynczej kategorii ksiki
   /// </summary>
   [Serializable]
   public class Category : AbstractEntity
   {

      // dane skadowe
      private string _name;

      public Category() { }
      public Category(int id, string name)
         : base(id)
      {
         _name = name;
      }

      public int Id
      {
         get { return (int)Key; }
         set { Key = value; }
      }
      public string Name
      {
         get { return _name; }
         set { _name = value; }
      }

      public override string ToString()
      {
         return Id + "," + Name;
      }

      /// <summary>
      /// Sprawdza, czy stan obiektu jest prawidowy
      /// </summary>
      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            if (Name == null)
            {
               AddBrokenRule("Kategoria: Nazwa musi mie nadan warto");
               return false;
            }

            if (Name.Length > 0)
               return true;
            else
            {
               AddBrokenRule("Kategoria: Nazwa jest pusta");
               return false;
            }
         }
      }
   }
}
