using System;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

/// <summary>
/// Oglny opis BookService
/// </summary>
[WebService(Namespace = "http://www.coreaspnet.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class BookService : System.Web.Services.WebService {

    public BookService () {   }

   [WebMethod]
   public string[] GetTitleSuggestions(string prefixText, int count)
   {
      // najpierw pobierz list ksiek, ktre odpowiadaj danym wprowadzonym przez uytkownika
      BookCatalogLogic logic = new BookCatalogLogic();
      EntityCollection<Book> books = logic.GetBooksByTitle(prefixText);

      // jeli takich ksiek nie ma, zwr warto null
      if (books == null || books.Count == 0)
         return null;
      else
      {
         // naley zwrci nie wicej ksiek, ni to okrelono w parametrze count
         int countOfTitles = books.Count;
         if (countOfTitles > count) countOfTitles = count;

         // utwrz tablic ze zwracanymi danymi
         string[] titles = new string[countOfTitles];
         // wypenij tablic na podstawie listy ksiek
         for (int i = 0; i < countOfTitles; i++)
         {
            // zwr tylko 16 pierwszych liter tytuu
            int maxLen = 16;
            if (maxLen > books[i].Title.Length) maxLen = books[i].Title.Length;
            titles[i] = books[i].Title.Substring(0, maxLen);
         }
         return titles;
      }
    }
    
}

