﻿using System.Net.Http;
using System.Threading.Tasks;
using System.Collections.Generic;

namespace LanguageFeatures.Models
{
    public class MyAsyncMethods
    {
        public async static Task<long?> GetPageLength()
        {
            HttpClient client = new HttpClient();
            var httpMessage = await client.GetAsync("http://apress.com");
            return httpMessage.Content.Headers.ContentLength;
        }

        public static async IAsyncEnumerable<long?>
               GetPageLengths(List<string> output, params string[] urls)
        {
            {
                List<long?> results = new List<long?>();
                HttpClient client = new HttpClient();
                foreach (string url in urls)
                {
                    output.Add($"Rozpoczęto wykonywanie żądania do {url}");
                    var httpMessage = await client.GetAsync($"http://{url}");
                    results.Add(httpMessage.Content.Headers.ContentLength);
                    output.Add($"Zakończono  wykonywanie żądania do {url}");
                    yield return httpMessage.Content.Headers.ContentLength;
                }
            }
        }
    }
}