﻿using Microsoft.EntityFrameworkCore;
using System.Linq;
namespace WebApp.Models
{
    public static class SeedData
    {
        public static void SeedDatabase(DataContext context)
        {
            context.Database.Migrate();
            if (context.Products.Count() == 0 && context.Suppliers.Count() == 0
                    && context.Categories.Count() == 0)
            {
                Supplier s1 = new Supplier
                { Name = "Wodny raj", City = "Gdańsk" };
                Supplier s2 = new Supplier
                { Name = "Piłkarskie szaleństwo", City = "Poznań" };
                Supplier s3 = new Supplier
                { Name = "Szachy SA", City = "Warszawa" };

                Category c1 = new Category { Name = "Sporty wodne" };
                Category c2 = new Category { Name = "Piłka nożna" };
                Category c3 = new Category { Name = "Szachy" };

                context.Products.AddRange(
                    new Product
                    {
                        Name = "Kajak",
                        Price = 275,
                        Category = c1,
                        Supplier = s1
                    },
                    new Product
                    {
                        Name = "Kamizelka ratunkowa",
                        Price = 48.95m,
                        Category = c1,
                        Supplier = s1
                    },
                    new Product
                    {
                        Name = "Piłka",
                        Price = 19.50m,
                        Category = c2,
                        Supplier = s2
                    },
                    new Product
                    {
                        Name = "Flagi narożne",
                        Price = 34.95m,
                        Category = c2,
                        Supplier = s2
                    },
                    new Product
                    {
                        Name = "Stadion",
                        Price = 79500,
                        Category = c2,
                        Supplier = s2
                    },
                    new Product
                    {
                        Name = "Czapka",
                        Price = 16,
                        Category = c3,
                        Supplier = s3
                    },
                    new Product
                    {
                        Name = "Niestabilne krzesło",
                        Price = 29.95m,
                        Category = c3,
                        Supplier = s3
                    },
                    new Product
                    {
                        Name = "Ludzka szachownica",
                        Price = 75,
                        Category = c3,
                        Supplier = s3
                    },
                    new Product
                    {
                        Name = "Błyszczący król",
                        Price = 1200,
                        Category = c3,
                        Supplier = s3
                    }
                );
                context.SaveChanges();
            }
        }
    }
}