﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Frontend.ViewModels;
using Frontend.Services;

namespace Frontend.Controllers
{
    [Produces("application/json")]
    [Route("api/TimingPoints")]
    public class TimingPointsController : Controller
    {
        private readonly ITimingService _service;

        public TimingPointsController(ITimingService service)
        {
            _service = service;
        }
        [HttpGet]
        public IList<TimingPointDefinition> Get()
        {
            var data = _service.GetTimingPoints(1);

            var model = data.Select(tp => new TimingPointDefinition
            {
                Code = tp.Code,
                Name = tp.Name,
                Order = tp.ID
            }).ToList();

            return model;
        }
    }
}