/// <reference path="../../../../node_modules/@types/jasmine/index.d.ts" />
import { assert } from 'chai';
import { CounterComponent } from './counter.component';
import { TestBed, async, ComponentFixture } from '@angular/core/testing';

let fixture: ComponentFixture<CounterComponent>;

describe('Komponent licznika', () => {
    beforeEach(() => {
        TestBed.configureTestingModule({ declarations: [CounterComponent] });
        fixture = TestBed.createComponent(CounterComponent);
        fixture.detectChanges();
    });

    it('Powinien wyświetlić tytuł', async(() => {
        const titleText = fixture.nativeElement.querySelector('h1').textContent;
        expect(titleText).toEqual('Licznik');
    }));

    it('Na początku powinien mieć wartość 0, a kliknięcie przycisku ma ją zwiększać o 1', async(() => {
        const countElement = fixture.nativeElement.querySelector('strong');
        expect(countElement.textContent).toEqual('0');

        const incrementButton = fixture.nativeElement.querySelector('button');
        incrementButton.click();
        fixture.detectChanges();
        expect(countElement.textContent).toEqual('1');
    }));
});
