import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';
import { RouterModule } from '@angular/router';

import { AppComponent } from './components/app/app.component';
import { NavMenuComponent } from './components/navmenu/navmenu.component';
import { HomeComponent } from './components/home/home.component';
import { ResultsComponent } from './components/results/results.component';
import { CounterComponent } from './components/counter/counter.component';

import { AthleteService } from './components/results/athlete.service';
import { ResultsListComponent } from './components/results/results-list.component';
import { AthleteComponent } from './components/results/athlete.component';
import { AthleteDetailsComponent } from './components/results/athlete-details.component'

@NgModule({
    declarations: [
        AppComponent,
        NavMenuComponent,
        CounterComponent,
        ResultsComponent,
        ResultsListComponent,
        AthleteComponent,
        AthleteDetailsComponent,
        HomeComponent
    ],
    providers: [AthleteService],
    imports: [
        CommonModule,
        HttpModule,
        FormsModule,
        RouterModule.forRoot([
            { path: '', redirectTo: 'home', pathMatch: 'full' },
            { path: 'home', component: HomeComponent },
            { path: 'counter', component: CounterComponent },
            { path: 'results', component: ResultsComponent },
            { path: '**', redirectTo: 'home' }
        ])
    ]
})
export class AppModuleShared {
}
