
Partial Class ProfileInfo
    Inherits System.Web.UI.Page

Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
	If Profile.IsAnonymous = False Then
		Profile.lastName = Me.txtLastName.Text
		Profile.firstName = Me.txtFirstName.Text
		Profile.phoneNumber = Me.txtPhone.Text
		Profile.birthDate = CType(Me.txtBirthDate.Text, System.DateTime)

		Profile.Sports = New System.Collections.Specialized.StringCollection()
		For Each item As ListItem In Me.cblSports.Items
			If item.Selected Then
				Profile.Sports.Add(item.Value.ToString())
			End If
		Next

	End If
	Response.Redirect("Welcome.aspx")
End Sub

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
		If Not IsPostBack And Profile.UserName IsNot Nothing Then
			If Profile.IsAnonymous = False Then
				Me.txtLastName.Text = Profile.lastName
				Me.txtFirstName.Text = Profile.firstName
				Me.txtPhone.Text = Profile.phoneNumber
				Me.txtBirthDate.Text = Profile.birthDate.ToShortDateString()
			End If

			If Profile.Sports IsNot Nothing Then
				For Each item As ListItem In Me.cblSports.Items
					For Each profileString As String In Profile.Sports
						If item.Text = profileString Then
							item.Selected = True
						End If
					Next
				Next
			End If
		End If
	End Sub
End Class
