﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using SportsStore.Models;
using System.Web.Security;

namespace SportsStore.Controllers
{
    public class AccountController : Controller
    {
        public ViewResult LogOn()
        {
            return View();
        }

        [HttpPost]
        public ActionResult LogOn(LogOnViewModel model, string returnUrl)
        {
            if (ModelState.IsValid) // nie ma potrzeby uwierzytelniania, jeżeli model jest nieprawidłowy
                if (!FormsAuthentication.Authenticate(model.UserName, model.Password))
                    ModelState.AddModelError("", "Błędna nazwa użytkownika lub hasło");

            if (ModelState.IsValid)
            {
                // Utwórz cookie i wykonaj przekierowanie (do strony głównej administratora
                // jeżeli nie ma podanego adresu powrotnego) 
                FormsAuthentication.SetAuthCookie(model.UserName, false);
                return Redirect(returnUrl ?? Url.Action("Index", "Admin"));
            }
            else
                return View();
        }
    }
}
