﻿using System.Linq;
using System.Data.Linq.Mapping;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using System.ComponentModel;

namespace SportsStore.Domain.Entities
{
    [Table(Name = "Products")]
    public class Product
    {
        [HiddenInput(DisplayValue = false)] 
        [Column(IsPrimaryKey = true, IsDbGenerated = true, AutoSync = AutoSync.OnInsert)]
        public int ProductID { get; set; }


        [Required(ErrorMessage = "Prosze podać nazwę produktu.")]
        [DisplayName("Nazwa")]
        [Column] public string Name { get; set; }

        [Required(ErrorMessage = "Proszę podać opis.")]
        [DataType(DataType.MultilineText)]
        [DisplayName("Opis")]
        [Column] public string Description { get; set; }

        [Required]
        [Range(0.01, double.MaxValue, ErrorMessage = "Proszę podać dodatnią cenę.")]
        [DisplayName("Cena")]
        [Column] public decimal Price { get; set; }

        [Required(ErrorMessage = "Proszę podać kategorię.")]
        [DisplayName("Kategoria")]
        [Column] public string Category { get; set; }
    
        [Column]
        public byte[] ImageData { get; set; }
        [ScaffoldColumn(false)]
        [Column]
        public string ImageMimeType { get; set; }
    } 

} 

