﻿using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace Planner.Models
{
    public class TaskRepository : ITaskRepository
    {
        /// <summary>
        /// Obiekt klasy kontekstowej.
        /// </summary>
        private TaskContext db = new TaskContext();

        /// <summary>
        /// Pobranie listy zadań.
        /// </summary>
        /// <returns>Lista zadań.</returns>
        public IEnumerable<Task> Get()
        {
            return db.Tasks.OrderBy(t => t.StartDate);
        }

        /// <summary>
        /// Pobranie zadania o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator zadania.</param>
        /// <returns>Zadanie o podanym identyfikatorze.</returns>
        public Task Get(int id)
        {
            return db.Tasks.Find(id);
        }

        /// <summary>
        /// Dodanie zadania.
        /// </summary>
        /// <param name="task">Dodawane zadanie</param>
        /// <returns>Dodane zadanie.</returns>
        public Task Add(Task task)
        {
            db.Tasks.Add(task);
            db.SaveChanges();
            return task;
        }

        /// <summary>
        /// Usunięcie zadania o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator usuwanego zadania.</param>
        public void Remove(int id)
        {
            Task task = db.Tasks.Find(id);
            db.Tasks.Remove(task);
            db.SaveChanges();
        }
    }
}
