﻿using System.Collections.Generic;

namespace Planner.Models
{
    public interface ITaskRepository
    {
        /// <summary>
        /// Pobranie listy zadań.
        /// </summary>
        /// <returns>Lista zadań.</returns>
        IEnumerable<Task> Get();

        /// <summary>
        /// Pobranie zadania o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator zadania.</param>
        /// <returns>Zadanie o podanym identyfikatorze.</returns>
        Task Get(int id);

        /// <summary>
        /// Dodanie zadania.
        /// </summary>
        /// <param name="task">Dodawane zadanie</param>
        /// <returns>Dodane zadanie.</returns>
        Task Add(Task task);

        /// <summary>
        /// Usunięcie zadania o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator usuwanego zadania.</param>
        void Remove(int id);
    }
}
