﻿using System;
using System.Linq;
using System.Web.Mvc;
using System.Web.Security;
using PortalUslug.Helpers;
using PortalUslug.Models;
using PortalUslug.Repositories;

namespace PortalUslug.Controllers
{
    [Authorize(Roles = "Administrator")]
    public class NewsletterController : Controller
    {
        /// <summary>
        /// Repozytorium usługodawcy.
        /// </summary>
        private ServiceProviderRepository _serviceProviderRepo;

        /// <summary>
        /// Repozytorium usługobiorcy.
        /// </summary>
        private CustomerRepository _customerRepo;

        /// <summary>
        /// Konstruktor kontrolera newsletter.
        /// </summary>
        public NewsletterController()
        {
            // Inicjalizacja repozytoriów 
            _serviceProviderRepo = new ServiceProviderRepository();
            _customerRepo = new CustomerRepository();
        }

        public ActionResult Send()
        {
            return View();
        }

        [HttpPost]
        public ActionResult Send(Newsletter news)
        {
            if (ModelState.IsValid)
            {
                // Pobranie usługobiorców i usługodawców, do których należy wysłać newsletter
                var customer = _customerRepo.GetAllCustomersWithNewsletter();
                var serviceProvider = _serviceProviderRepo.GetAllServiceProvidersWithNewsletter();

                // Utworzenie listy e-maili użytkowników, do których należy wysłać newsletter
                var customerEmails = customer.Select(u => u.Email).ToList();
                var serviceProviderEmails = serviceProvider.Select(u => u.Email).ToList();

                customerEmails.AddRange(serviceProviderEmails);
                
                if (customerEmails.Count > 0)
                {
                    // Wykorzystanie helpera do wysyłania e-maili
                    MailHelper.SendEmail(customerEmails, news.Subject, news.Content);
                    return View("Sent");
                }
                else
                {
                    TempData["Error"] = "Brak aktywnych użytkowników. Newsletter nie został wysłany.";
                    return View();
                }
            }

            // W przypadku błędów zwrócenie aktualnego widoku
            return View(news);
        }
    }
}
