﻿using System;
using System.Linq;
using PortalUslug.Models;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Interfejs repozytorium komentarza.
    /// </summary>
    public interface ICommentRepository : IRepository<Comment>
    {
        /// <summary>
        /// Pobranie komentarza o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator komentarza.</param>
        /// <returns>Komentarz o podanym identyfikatorze.</returns>
        Comment GetCommentById(int id);

        /// <summary>
        /// Sprawdzenie, czy użytkownik o podanym identyfikatorze dodał komentarz/-e.
        /// </summary>
        /// <param name="userId">Identyfikator użytkownika.</param>
        /// <returns>True, jeśli użytkownik dodał komentarz/-e.</returns>
        bool HasUserComment(int userId);

        /// <summary>
        /// Pobranie komentarzy do usługi o podanym identyfikatorze usługi.
        /// </summary>
        /// <param name="serviceId">Identyfikator usługi.</param>
        /// <returns>Komentarze usługi o podanym identyfikatorze usługi.</returns>
        IQueryable<CommentViewModel> GetCommentByServiceId(int serviceId);
    }
}
