﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ListViewCustomRows.aspx.cs"
    Inherits="ListViewCustomRows" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Kontrolka ListView</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:SqlDataSource ID="dsCustomers" runat="server" ConnectionString="<%$ ConnectionStrings:AWLTConnection %>"
            SelectCommand="SELECT	[CustomerID], [NameStyle],
	CASE WHEN [Title] IS NULL THEN '' ELSE [Title] + ' ' END +
    [FirstName] + ' ' +
	CASE WHEN [MiddleName] IS NULL THEN '' ELSE [MiddleName] + ' ' END +
	[LastName] + 
	CASE WHEN [Suffix] IS NULL THEN '' ELSE ' ' + [Suffix] END as 'FullName',
	[Title], [FirstName], [MiddleName], [LastName], [Suffix],
	[CompanyName], [SalesPerson], [ModifiedDate], [EmailAddress], [Phone], 
	[PasswordHash], [PasswordSalt]
FROM [SalesLT].[Customer]" InsertCommand="INSERT INTO [SalesLT].[Customer] ([NameStyle], [Title], [FirstName], [MiddleName], [LastName], [Suffix], [CompanyName], [SalesPerson], [EmailAddress], [Phone], [PasswordHash], [PasswordSalt]) VALUES (@NameStyle, @Title, @FirstName, @MiddleName, @LastName, @Suffix, @CompanyName, @SalesPerson, @EmailAddress, @Phone, @PasswordHash, @PasswordSalt)"
            UpdateCommand="UPDATE [SalesLT].[Customer] SET [NameStyle] = @NameStyle, [Title] = @Title, [FirstName] = @FirstName, [MiddleName] = @MiddleName, [LastName] = @LastName, [Suffix] = @Suffix, [CompanyName] = @CompanyName, [SalesPerson] = @SalesPerson, [EmailAddress] = @EmailAddress, [Phone] = @Phone, [ModifiedDate] = GetDate() WHERE [CustomerID] = @CustomerID"
            DeleteCommand="DELETE FROM [SalesLT].[Customer] WHERE [CustomerID] = @CustomerID">
            <DeleteParameters>
                <asp:Parameter Name="CustomerID" Type="Int32" />
            </DeleteParameters>
            <UpdateParameters>
                <asp:Parameter Name="NameStyle" Type="Boolean" />
                <asp:Parameter Name="Title" Type="String" />
                <asp:Parameter Name="FirstName" Type="String" />
                <asp:Parameter Name="MiddleName" Type="String" />
                <asp:Parameter Name="LastName" Type="String" />
                <asp:Parameter Name="Suffix" Type="String" />
                <asp:Parameter Name="CompanyName" Type="String" />
                <asp:Parameter Name="SalesPerson" Type="String" />
                <asp:Parameter Name="EmailAddress" Type="String" />
                <asp:Parameter Name="Phone" Type="String" />
                <asp:Parameter Name="CustomerID" Type="Int32" />
            </UpdateParameters>
            <InsertParameters>
                <asp:Parameter Name="NameStyle" Type="Boolean" />
                <asp:Parameter Name="Title" Type="String" />
                <asp:Parameter Name="FirstName" Type="String" />
                <asp:Parameter Name="MiddleName" Type="String" />
                <asp:Parameter Name="LastName" Type="String" />
                <asp:Parameter Name="Suffix" Type="String" />
                <asp:Parameter Name="CompanyName" Type="String" />
                <asp:Parameter Name="SalesPerson" Type="String" />
                <asp:Parameter Name="EmailAddress" Type="String" />
                <asp:Parameter Name="Phone" Type="String" />
                <asp:Parameter Name="PasswordHash" Type="String" />
                <asp:Parameter Name="PasswordSalt" Type="String" />
            </InsertParameters>
        </asp:SqlDataSource>
        <br />
        <asp:ListView ID="ListView1" runat="server" DataKeyNames="CustomerID" DataSourceID="dsCustomers"
            GroupItemCount="2" OnItemInserting="lvw_ItemInserting" InsertItemPosition="FirstItem">
            <LayoutTemplate>
                <table>
                    <asp:PlaceHolder ID="groupPlaceholder" runat="server" />
                </table>
            </LayoutTemplate>
            <GroupTemplate>
                <tr>
                    <asp:PlaceHolder runat="server" ID="itemPlaceholder" />
                </tr>
            </GroupTemplate>
            <ItemTemplate>
                <td>
                    Imię i nazwisko:
                    <asp:Label ID="FullNameLabel" runat="server" Text='<%# Eval("FullName") %>' />
                    <br />
                    Nazwa firmy:
                    <asp:Label ID="CompanyNameLabel" runat="server" Text='<%# Eval("CompanyName") %>' />
                    <br />
                    Przedstawiciel:
                    <asp:Label ID="SalesPersonLabel" runat="server" Text='<%# Eval("SalesPerson") %>' />
                    <br />
                    Data ostatniej modyfikacji:
                    <asp:Label ID="ModifiedDateLabel" runat="server" Text='<%# Eval("ModifiedDate", "{0:dd/MM/yyyy}") %>' />
                    <br />
                    Adres e-mail:
                    <asp:HyperLink ID="hypEmailReadOnly" runat="server" NavigateUrl='<%# Eval("EmailAddress", "mailto:{0}") %>'
                        Text='<%# Eval("EmailAddress") %>' />
                    <br />
                    Telefon:
                    <asp:Label ID="PhoneLabel" runat="server" Text='<%# Eval("Phone") %>' />
                    <br />
                    Wartość hash:
                    <asp:Label ID="PasswordHashLabel" runat="server" Text='<%# Eval("PasswordHash") %>' />
                    <br />
                    Wartość salt:
                    <asp:Label ID="PasswordSaltLabel" runat="server" Text='<%# Eval("PasswordSalt") %>' />
                    <br />
                    <asp:Button runat="server" ID="btnEdit" Text="Edytuj" CommandName="Edit" CausesValidation="false" />
                    <asp:Button runat="server" ID="btnDelete" Text="Usuń" CommandName="Delete" CausesValidation="false" />
                </td>
            </ItemTemplate>
            <EditItemTemplate>
                <td>
                    Nazwa stylu:
                    <asp:CheckBox ID="NameStyleCheckBox" runat="server" Checked='<%# Bind("NameStyle") %>' />
                    <br />
                    Tytuł:
                    <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>' />
                    <br />
                    Imię:
                    <asp:TextBox ID="FirstNameTextBox" runat="server" Text='<%# Bind("FirstName") %>' />
                    <br />
                    Drugie imię:
                    <asp:TextBox ID="MiddleNameTextBox" runat="server" Text='<%# Bind("MiddleName") %>' />
                    <br />
                    Nazwisko:
                    <asp:TextBox ID="LastNameTextBox" runat="server" Text='<%# Bind("LastName") %>' />
                    <br />
                    Przyrostek:
                    <asp:TextBox ID="SuffixTextBox" runat="server" Text='<%# Bind("Suffix") %>' />
                    <br />
                    Nazwa firmy:
                    <asp:TextBox ID="CompanyNameTextBox" runat="server" Text='<%# Bind("CompanyName") %>' />
                    <br />
                    Przedstawiciel:
                    <asp:TextBox ID="SalesPersonTextBox" runat="server" Text='<%# Bind("SalesPerson") %>' />
                    <br />
                    Adres e-mail:
                    <asp:TextBox ID="EmailAddressTextBox" runat="server" Text='<%# Bind("EmailAddress") %>' />
                    <br />
                    Telefon:
                    <asp:TextBox ID="PhoneTextBox" runat="server" Text='<%# Bind("Phone") %>' />
                    <br />
                    <asp:Button runat="server" ID="btnUpdate" Text="Aktualizuj" CommandName="Update" CausesValidation="true" />
                    <asp:Button runat="server" ID="btnCancel" Text="Anuluj" CommandName="Cancel" CausesValidation="false" />
                </td>
            </EditItemTemplate>
            <InsertItemTemplate>
                <td>
                    Nazwa stylu:
                    <asp:CheckBox ID="NameStyleCheckBox" runat="server" Checked='<%# Bind("NameStyle") %>' />
                    <br />
                    Tytuł:
                    <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>' />
                    <br />
                    Imię:
                    <asp:TextBox ID="FirstNameTextBox" runat="server" Text='<%# Bind("FirstName") %>' />
                    <br />
                    Drugie imię:
                    <asp:TextBox ID="MiddleNameTextBox" runat="server" Text='<%# Bind("MiddleName") %>' />
                    <br />
                    Nazwisko:
                    <asp:TextBox ID="LastNameTextBox" runat="server" Text='<%# Bind("LastName") %>' />
                    <br />
                    Przyrostek:
                    <asp:TextBox ID="SuffixTextBox" runat="server" Text='<%# Bind("Suffix") %>' />
                    <br />
                    Nazwa firmy:
                    <asp:TextBox ID="CompanyNameTextBox" runat="server" Text='<%# Bind("CompanyName") %>' />
                    <br />
                    Przedstawiciel:
                    <asp:TextBox ID="SalesPersonTextBox" runat="server" Text='<%# Bind("SalesPerson") %>' />
                    <br />
                    Adres e-mail:
                    <asp:TextBox ID="EmailAddressTextBox" runat="server" Text='<%# Bind("EmailAddress") %>' />
                    <br />
                    Telefon:
                    <asp:TextBox ID="PhoneTextBox" runat="server" Text='<%# Bind("Phone") %>' />
                    <br />
                    Hasło:
                    <asp:TextBox ID="NewPasswordTextBox" runat="server" />
                    <br />
                    <asp:Button ID="InsertButton" runat="server" CommandName="Insert" Text="Wstaw" CausesValidation="true" />
                    <asp:Button ID="CancelButton" runat="server" CommandName="Cancel" Text="Wyczyść" CausesValidation="false" />
                </td>
            </InsertItemTemplate>
            <EmptyDataTemplate>
                <td>
                    Nie zwrócono żadnych danych.
                </td>
            </EmptyDataTemplate>
        </asp:ListView>
        <asp:DataPager ID="DataPager1" runat="server" PageSize="3" PagedControlID="ListView1">
            <Fields>
                <asp:NextPreviousPagerField ButtonType="Button" ShowFirstPageButton="True" ShowLastPageButton="True" />
            </Fields>
        </asp:DataPager>
    </div>
    </form>
</body>
</html>
