﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ComparePasswordStrength.aspx.cs"
    Inherits="ComparePasswordStrength" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Kontrolka pokazująca siłę hasła</title>

    <script type="text/javascript">

        function pageLoad() {
        }
    
    </script>

    <style media="screen" type="text/css">
        .VPoor
        {
            background-color: Gray;
            color: White;
            font-family: Arial;
            font-size: x-small;
            font-style: italic;
            padding: 2px 3px 2px 3px;
            font-weight: bold;
        }
        .Weak
        {
            background-color: Gray;
            color: Yellow;
            font-family: Arial;
            font-size: x-small;
            font-style: italic;
            padding: 2px 3px 2px 3px;
            font-weight: bold;
        }
        .Average
        {
            background-color: Gray;
            color: #FFCAAF;
            font-family: Arial;
            font-size: x-small;
            font-style: italic;
            padding: 2px 3px 2px 3px;
            font-weight: bold;
        }
        .Strong
        {
            background-color: Gray;
            color: Aqua;
            font-family: Arial;
            font-size: x-small;
            font-style: italic;
            padding: 2px 3px 2px 3px;
            font-weight: bold;
        }
        .Excellent
        {
            background-color: Gray;
            color: #93FF9E;
            font-family: Arial;
            font-size: x-small;
            font-style: italic;
            padding: 2px 3px 2px 3px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>
        Kontrolka pokazująca siłę hasła
    </h1>
    <form runat="server" id="frmBugs">
    <div>
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <table cellpadding="3" border="1">
            <tr>
                <td colspan="3" align="center">
                    <asp:Label ID="lblMsg" Text="Proszę poniżej umieścić informacje dotyczące błędu" runat="server" />
                </td>
            </tr>
            <tr>
                <td>
                    Książka
                </td>
                <td>
                    <asp:DropDownList ID="ddlBooks" runat="server">
                        <asp:ListItem>-- Proszę zaznaczyć książkę --</asp:ListItem>
                        <asp:ListItem>Programming ASP.NET</asp:ListItem>
                        <asp:ListItem>Learning ASP.NET With AJAX</asp:ListItem>
                        <asp:ListItem>Programming C# 2008</asp:ListItem>
                        <asp:ListItem>Programming Visual Basic 2008</asp:ListItem>
                    </asp:DropDownList>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="rfvBooks" ControlToValidate="ddlBooks" Display="Static"
                        InitialValue="-- Proszę zaznaczyć książkę --" runat="server" ErrorMessage="Proszę wybrać książkę"
                        Text="*" />
                </td>
            </tr>
            <tr>
                <td>
                    Edycja:
                </td>
                <td>
                    <asp:RadioButtonList ID="rblEdition" RepeatLayout="Flow" runat="server">
                        <asp:ListItem>1st</asp:ListItem>
                        <asp:ListItem>2nd</asp:ListItem>
                        <asp:ListItem>3rd</asp:ListItem>
                        <asp:ListItem>4th</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="rfvEdition" runat="server" ControlToValidate="rblEdition"
                        Display="Static" ErrorMessage="Proszę wybrać edycję książki" Text="*" />
                </td>
            </tr>
            <tr>
                <td>
                    Błąd:
                </td>
                <td>
                    <asp:TextBox ID="txtBug" runat="server" TextMode="MultiLine" />
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="rfvBug" ControlToValidate="txtBug" Display="Static"
                        runat="server" ErrorMessage="Proszę podać informacje o błędzie" Text="*" />
                </td>
            </tr>
            <tr>
                <td>
                    Numer strony:
                </td>
                <td>
                    <asp:TextBox ID="txtPageNumber" runat="server" />
                </td>
                <td>
                    <asp:RequiredFieldValidator runat="server" ID="rfvPageNumber" ControlToValidate="txtPageNumber"
                        ErrorMessage="Nie podano numeru strony" Text="*" />
                    <asp:CompareValidator runat="server" ID="cmpPageNumber" ControlToValidate="txtPageNumber"
                        ErrorMessage="Nieprawidłowy numer strony" Type="Integer" Operator="DataTypeCheck" Text="*" />
                </td>
            </tr>
            <tr>
                <td>
                    Proszę podać hasło:
                </td>
                <td>
                    <asp:TextBox ID="txtPassword1" runat="server" TextMode="Password" />
                    <cc1:PasswordStrength ID="txtPassword1_PasswordStrength" runat="server" Enabled="True"
                        TargetControlID="txtPassword1" DisplayPosition="RightSide" StrengthIndicatorType="Text"
                        PreferredPasswordLength="10" PrefixText="Strength:" 
                        TextStrengthDescriptions="Niewystarczające;Słabe;Przeciętne;Silne;Doskonałe" StrengthStyles="VPoor;Weak;Average;Strong;Excellent"
                        MinimumNumericCharacters="0" MinimumSymbolCharacters="0" RequiresUpperAndLowerCaseCharacters="false">
                    </cc1:PasswordStrength>
                </td>
                <td>
                    <!-- Wymagane do podania hasła -->
                    <asp:RequiredFieldValidator runat="server" ID="rfvPassword1" ControlToValidate="txtPassword1"
                        ErrorMessage="Proszę podać hasło" Text="*" />
                </td>
            </tr>
            <!-- Drugie hasło, w celu porównania -->
            <tr>
                <td>
                    Proszę ponownie podać hasło:
                </td>
                <td>
                    <asp:TextBox ID="txtPassword2" runat="server" TextMode="Password" />
                </td>
                <td>
                    <!-- Drugie hasło jest wymagane -->
                    <asp:RequiredFieldValidator runat="server" ID="rfvPassword2" ControlToValidate="txtPassword2"
                        ErrorMessage="Proszę ponownie podać hasło" Text="*" />
                    <!-- Drugie podane hasło musi odpowiadać pierwszemu -->
                    <asp:CompareValidator runat="server" ID="cmpPasswords" ControlToValidate="txtPassword2"
                        ErrorMessage="Podano różne hasła" Type="String" Operator="Equal" ControlToCompare="txtPassword1"
                        Text="*" />
                </td>
            </tr>
            <tr>
                <td colspan="3" align="center">
                    <asp:Button ID="btnSubmit" Text="Zgłoś błąd" runat="server" />
                </td>
            </tr>
        </table>
        <asp:ValidationSummary ID="ValidationSummary1" runat="server" DisplayMode="BulletList"
            HeaderText="Zostały znalezione następujące błędy: " ShowSummary="true" />
    </form>
</body>
</html>
