 ;
 ; ===========================================================
 ;  \Win32ASM\Src\TransMenu\TransMenu.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Demonstruje jak stworzy przezroczyste menu
 ; ===========================================================

 include ..\..\makro.inc

 INCLUDEX kernel32
 INCLUDEX user32

.data?                         ; sekcja danych bez wart. pocz.
 hInst         dd ?
 hMainWnd      dd ?
 hEdit         dd ?
 hHookID       dd ?
 hMenu         dd ?
 hMenuPlik     dd ?
 wc WNDCLASSEX <>
 msg MSG       <>

.data                          ; sekcja danych
  wcClass           db 'transMenuWndClass',NULL
  editClass         db 'EDIT',NULL
  txMenuPlik        db '&Plik',NULL
  txMenuPlikNowy    db '&Nowy',NULL
  txMenuPlikOtworz  db '&Otwrz',NULL
  txMenuPlikPozycja db '&Bardzo dugi tekst w menu',NULL
  txMenuPlikZakoncz db '&Zakocz',NULL
  menuClass         db '#32768',NULL
  modUSER32         db 'USER32.DLL',NULL
  funSetLayWinAtr   db 'SetLayeredWindowAttributes',NULL
  tyt               db 'Okienko z przezroczystym menu',NULL
  PropStaraProcka   db 'StaraProcka',NULL
  edtText          \
   db 'Programowanie w Win32ASM to wietna okazja, aby pozna'
   db ' sztuczki, ktre mona pniej wykorzystywa w innych'
   db ' jzykach programowania; w tych ostatnich, stworzenie'
   db ' niektrych efektw jest z reszt o wiele bardziej'
   db ' uciliwe',NULL

.code                          ; sekcja kodu
  WS_EX_LAYERED = 00080000h
  LWA_ALPHA     = 00000002h

  ProckaMenu proc hWnd,uMsg,wPar,lPar:DWORD
    LOCAL staraProcka:DWORD
    LOCAL hUser32:DWORD
    INV  GetProp,hWnd,OFS PropStaraProcka
    mov  staraProcka,eax
    .if uMsg==WM_CREATE
       INV  GetModuleHandle,OFS modUSER32
       INV  GetProcAddress,eax,OFS funSetLayWinAtr
       .if eax!=0
           push eax
           INV  GetWindowLong,hWnd,GWL_EXSTYLE
           or   eax,WS_EX_LAYERED
           INV  SetWindowLong,hWnd,GWL_EXSTYLE,eax
           pop  eax

           push LWA_ALPHA
           push 255*75/100
           push 0
           push hWnd
           call eax
       .endif
    .elseif uMsg==WM_DESTROY
       INV  RemoveProp,hWnd,OFS PropStaraProcka
       INV  SetWindowLong,hWnd,GWL_WNDPROC,eax
    .endif
    INV  CallWindowProc,staraProcka,hWnd,uMsg,wPar,lPar
    ret
  ProckaMenu endp

  hookProc proc nCod,wPar,lPar:DWORD
    LOCAL cwps:CWPSTRUCT
    LOCAL tmpClass[128]:BYTE
    .if nCod==HC_ACTION
      mov  esi,lPar
      lea  edi,cwps
      mov  ecx,SIZEOF cwps
      cld
      rep  movsb
      .if cwps.message==WM_CREATE
         INV  GetClassName,cwps.hwnd,ADDR tmpClass,SIZEOF tmpClass
         INV  lstrcmpi,ADDR tmpClass,OFS menuClass
         .if eax==0
            INV SetWindowLong,cwps.hwnd,GWL_WNDPROC,OFS ProckaMenu
            INV SetProp,cwps.hwnd,OFS PropStaraProcka,eax
         .endif
      .endif
    .endif
    INV  CallNextHookEx,WH_CALLWNDPROC,nCod,wPar,lPar
    ret
  hookProc endp

  mainWndProc proc hWnd,uMsg,wPar,lPar:DWORD
    LOCAL rc:RECT
      .if uMsg==WM_CREATE
         INV  GetWindowThreadProcessId,hWnd,NULL
         INV  SetWindowsHookEx,WH_CALLWNDPROC,OFS hookProc,\
              NULL,eax
         mov  hHookID,eax

         INV  CreateMenu
         mov  hMenuPlik,eax
         INV  AppendMenu,hMenuPlik,MF_STRING,100,OFS txMenuPlikNowy
         INV  AppendMenu,hMenuPlik,MF_STRING,101,OFS txMenuPlikOtworz
         INV  AppendMenu,hMenuPlik,MF_SEPARATOR,NULL,NULL
         INV  AppendMenu,hMenuPlik,MF_STRING,102,OFS txMenuPlikZakoncz
         INV  AppendMenu,hMenuPlik,MF_STRING,103,OFS txMenuPlikPozycja

         INV  CreateMenu
         mov  hMenu,eax
         INV  AppendMenu,hMenu,MF_POPUP,hMenuPlik,OFS txMenuPlik
         INV  SetMenu,hWnd,hMenu
         INV  DrawMenuBar,hWnd

         INV  GetClientRect,hWnd,ADDR rc
         sub  rc.right,20
         sub  rc.bottom,20
         INV  CreateWindowEx,NULL,OFS editClass,NULL,WS_CHILD or \
                             WS_VISIBLE or ES_MULTILINE or \
                             WS_VSCROLL or \
                             ES_AUTOVSCROLL or \
                             ES_WANTRETURN,
                             10,10,rc.right,rc.bottom,hWnd,NULL,hInst,NULL
         mov  hEdit,eax
         INV  SetWindowText,hEdit,OFS edtText

         jmp  ret0

      .elseif uMsg==WM_DESTROY
        .if hHookID!=0
            INV  UnhookWindowsHookEx,hHookID
        .endif
        INV  PostQuitMessage,NULL
        jmp  ret0

      .endif
      INV DefWindowProc,hWnd,uMsg,wPar,lPar
      ret

    ret0:
      xor  eax,eax
      ret

  mainWndProc endp

  Start:                       ; pocztek programu
    INV  GetModuleHandle,NULL  ; pobieramy uchwyt moduu
    mov  hInst,eax             ; i zapisujemy go do zmiennej

    xor  eax,eax               ; struktura WNDCLASSEX
    mov  wc.cbSize,SIZEOF wc
    mov  wc.cbClsExtra,eax
    mov  wc.cbWndExtra,eax
    mov  wc.hbrBackground,1+COLOR_BTNFACE
    mov  wc.hIcon,eax
    mov  wc.lpfnWndProc,OFS mainWndProc
    mov  wc.lpszClassName,OFS wcClass
    mov  wc.lpszMenuName,NULL
    mov  wc.style,CS_HREDRAW or CS_VREDRAW
    INV  LoadCursor,NULL,IDC_ARROW
    mov  wc.hCursor,eax
    MOM  wc.hInstance,hInst
    INV  RegisterClassEx,OFS wc

    INV  CreateWindowEx,NULL,OFS wcClass,OFS tyt,\
                        WS_OVERLAPPEDWINDOW or WS_VISIBLE,\
                        CW_USEDEFAULT,CW_USEDEFAULT,
                        400,300,NULL,NULL,hInst,NULL
    mov  hMainWnd,eax
    INV  ShowWindow,hMainWnd,SW_SHOW

 petlaKom:
    xor  eax,eax
    INV  GetMessage,OFS msg,eax,eax,eax
    or   eax,eax
    je   Koniec
    INV  TranslateMessage,OFS msg
    INV  DispatchMessage,OFS msg
    jmp  petlaKom

  Koniec:
    INV  ExitProcess,msg.wParam

END Start                      ; tu zaczyna si program

