 ;
 ; ===========================================================
 ;  \Win32ASM\Src\Prisoner\Prisoner.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Okno, ktre nie moe "wyj" poza ekran.
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32

 ID_DLG_MAIN   = 100
 ID_CHANGE     = 1002

.data?                         ; dane niezainicjalizowane
 hInstance dd ?
 scrW      dd ?
 scrH      dd ?
 wa       RECT <>

.data                          ; dane zainicjalizowane
 bMagnet    dd TRUE
 szNormal   db 'Wcz  ',NULL
 szMagnes   db 'Wycz ',NULL
 
.code                          ; segment kodu (sekcja kodu)
   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
    LOCAL rc:RECT
    LOCAL dlgW,dlgH;DWORD
     pushad

     .IF  uMsg==WM_CLOSE
       INV EndDialog,hDlg,0

     .ELSEIF uMsg==WM_INITDIALOG
        INV    GetSystemMetrics,SM_CXSCREEN
        mov    scrW,eax
        INV    GetSystemMetrics,SM_CYSCREEN
        mov    scrH,eax

        INV    SystemParametersInfo,SPI_GETWORKAREA,0,ADDR wa,0

        INV    SetDlgItemText,hDlg,ID_CHANGE,OFS szMagnes

     .ELSEIF uMsg==WM_WINDOWPOSCHANGING
       .IF bMagnet==TRUE
          mov    edi,lParam
          mov    edx,[edi.WINDOWPOS.y]
          mov    eax,[edi.WINDOWPOS.x]
          MOM   dlgW,[edi.WINDOWPOS.lx]
          MOM   dlgH,[edi.WINDOWPOS.cy]

           ; X: sprawdzamy czy X < 0
          .IF (SGND eax<0)
            xor eax,eax
          .ENDIF

           ; X: sprawdzamy czy x+dlgW>scrW
          mov    ebx,scrW
          sub    ebx,dlgW
          .IF (SGND eax>ebx)
            mov eax,ebx
          .ENDIF

           ; Y: sprawdzamy czy Y < 0
          .IF (SGND edx<0)
            xor edx,edx
          .ENDIF

           ; Y: sprawdzamy czy y+dlgH>scrH
          mov    ebx,scrH
          sub    ebx,dlgH
          .IF (SGND edx>ebx)
            mov edx,ebx
          .ENDIF

          mov  [edi.WINDOWPOS.y],edx
          mov  [edi.WINDOWPOS.x],eax

       .ENDIF
     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==IDOK
          INV SendMessage,hDlg,WM_CLOSE,0,0

       .ELSEIF wParam==ID_CHANGE
          inc   bMagnet      ; \ na przemian wczony/
          and   bMagnet,1    ; / wyaczony

          mov   eax,bMagnet  ; eax=0 or 1
          shl   eax,3
          lea   eax,[eax+OFS szNormal]

          INV SetDlgItemText,hDlg,ID_CHANGE,eax
        .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                      ; pocztek programu

     INV GetModuleHandle,NULL
     mov hInstance,eax

     INV DialogBoxParam,hInstance,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV ExitProcess,0         ; zakoczenie programu

END Start                      ; tu zaczyna si program
