 ;
 ; =========================================================
 ;  \win32asm\makro.inc
 ; =======================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; =======================================================
 ;  Plik zawiera definicje makr i staych uywanych
 ;  w programach napisanych dla Windows.
 ;  Wszystkie nazwy makr pisane s wielkimi literami.
 ; =========================================================

.586                           ; instrukcje 586
.MODEL FLAT,STDCALL            ; paski model pamici

; ==========================================================
; makra pomocne przy pisaniu programw
; ==========================================================

; ==========================================================
; doczamy zawarto pliku windows.inc

   INCLUDE windows.inc

; ==========================================================
; znaki ASCII

   NUL   = 00h
   CR    = 0Dh
   TAB   = 09h
   LF    = 0Ah
   
; ==========================================================
; wskanik pusty
   NIL   = 0000000h

; ==========================================================
; przydatne skrty

   ADR  equ ADDR
   OFS  equ OFFSET
   BPTR equ BYTE PTR
   WPTR equ WORD PTR
   DPTR equ DWORD PTR
   INV  equ INVOKE
   SGND equ SDWORD PTR
   SGNW equ SWORD PTR   
   SGNB equ SBYTE PTR

; ==========================================================
; makro dziaa jak MOV dla dwch zmiennych w pamici
; np.    MOVM    [eax],[ebx]

  MOVM  MACRO dokad:REQ, skad:REQ
    push   skad
    pop    dokad
  ENDM

; ==========================================================
; to samo co powyej

  M2M  equ MOVM
  MOM  equ MOVM
  mom  equ MOVM
  movm equ MOVM

; ==========================================================
; makro zapisuje dan warto pod adres wskazywany przez
; wskanik np.    MOP    ppvObject,NULL

  MOP   MACRO dokad:REQ, co:REQ
    mov  eax,dokad
    MOVM [eax],co
  ENDM

; ==========================================================
; makro zwraca warto funkcji w eax
; np.    RETURN 0

  RETURN  MACRO arg:REQ
    mov    eax,arg
    ret
  ENDM

; ==========================================================
; makro zwraca w eax mniej znaczc cz sowa
; 32-bitowego
; np.    LOWORD lParam

  LOWORD  MACRO param:REQ
    mov    eax,param
    and    eax,0FFFFh
  ENDM

; ==========================================================
; makro zwraca w eax bardziej znaczc cz sowa
; 32-bitowego
; np.    HIWORD lParam

  HIWORD  MACRO param:REQ
    mov    eax,param
    shr    eax,16
  ENDM

; ==========================================================
; makro zwraca wiksz z dwch liczb p1 i p2 w eax
; np.    MAX    [ebx],[ecx]

  MAX  MACRO p1:REQ,p2:REQ
    mov    eax,p1
    .IF eax<p2
       mov    eax,p2
    .ENDIF
  ENDM

; ==========================================================
; makro zwraca mniejsz z dwch liczb p1 i p2 w eax
; np.    MIN [ebx],[ecx]

  MIN  MACRO p1:REQ,p2:REQ
    mov    eax,p1
    .IF eax>p2
       mov    eax,p2
    .ENDIF
  ENDM


; ==========================================================
; makro INCLUDEX powoduje doczenie plikw
; "nazwa.lib" i "nazwa.inc" do projektu
; np.    INCLUDEX kernel32

  INCLUDEX  MACRO plik:REQ
     include    plik.inc
     includelib plik.lib
  ENDM

; ==========================================================
; makro umieszcza tekst ASCIIZ w segmencie danych (.data)
; i zwraca do niego adres
; np.    mov eax,QTEXT("Test")

  QTEXT MACRO tekst
   LOCAL nazwa
    .data
       nazwa db tekst,NULL
    .code
  EXITM <OFS nazwa>
  ENDM

; ==========================================================
; makro definiuje zmienn tekstow ASCIIZ w segmencie danych
; (.data) i zwraca do niej adres
; np.    mov eax,DTEXT(TxTest,"Test")

  DTEXT MACRO nazwa,tekst
    .data
       nazwa db tekst,NULL
    .code

  EXITM <OFS nazwa>
  ENDM

; ==========================================================
; makro definiuje zmienn tekstow ASCIIZ w segmencie danych
; (.code) i zwraca do niej adres
; np.    mov    eax,CTEXT(TxTest,"Test")

  CTEXT MACRO nazwa,tekst
            LOCAL tmpLabel
    .code
      jmp   tmpLabel
        nazwa db tekst,NULL
      tmpLabel:

  EXITM <OFS nazwa>
  ENDM

; ==========================================================
; makro definiuje kolor RGB podany jako RGB
; i zwraca go jako BBGGRR (wymagane przez Windows)
; np.    mov eax,RGB (0FFh,0,0) ; czerwony

  RGB MACRO R,G,B
    EXITM <B shl 16+G shl 8+R>
  ENDM

; ==========================================================
; bardzo sprytne makro czsto wykorzystywane w wirusach
; - pozwala umieci na stosie adres do acucha, pozwalajc
; zmniejszy narzut zwizany z koniecznoci obliczenia
; adresu w oparciu o rejestr bazowy - rozkaz "call tmp"
; powoduje automatyczne zachowanie na stosie adresu do 
; acucha "str2push" (umieszczonego w kodzie); wywoanie
; procedury "tmp" powoduje przejcie do nastpnej instrukcji
; ktra moe teraz wywoa np. funkcj API, do ktrej 
; przekae adres acucha "str2push"
; np. push MB_OK
;     @pushsz "Hello World!"
;     @pushsz "Hello World!"
;     push 0
;     call MessageBoxA
; zostanie zamienione na kod
;     push MB_OK
;     call ety1
;     db "Hello World!",0
;   ety1:
;     call ety2
;     db "Hello World!",0
;   ety2:
;     push 0
;     call MessageBoxA

 @pushsz macro str2push
  local tmp
   call tmp
    db str2push,NULL
  tmp:
 endm

; ==========================================================
; makra pomocne przy debuggowaniu programw
; ==========================================================

; ==========================================================
; DEBUGX
;   makro to w wygodny sposb pozwala wywietli informacje
;   - liczby decymalne, heksalne, acuchy tekstu, adresy
;   (wykorzystuje funkcj wsprintf, ktra pozwala formatowa
;   acuchy tekstowe); DEBUGX pozwala okreli czas po 
;   jakim zostanie wznowione dalsze wykonywanie programu 
;   (czas podawany jest w milisekundach)
;   np. DEBUGX "eax zawiera: %d, a ecx:",100,eax,ecx
;   wywietla informacj o zawartoci rejestrw eax i ecx
;   oraz czeka 100ms, po czym wznawia dziaanie programu
;
; ==========================================================
; DEBUG
;   makro dziaa identycznie jak DEBUGX, z tym e opnienie
;   jest ustawione domylnie na 0ms

IF DEB eq 1
   ;
   ; makra i kod dla wersji DEBUG
   ;

  INCLUDEX kernel32
  INCLUDEX user32

 .data
  debTmpStr   db 1024 dup(?)
              db NULL
  debTmpBuf   db 1024 dup(?)
              db NULL
  debCRN      db CR,LF,NULL
  debHan      dd NULL
  debHexChars db '0123456789ABCDEF'

 .code
  DEBUGX MACRO debPat:REQ, debDel:=<0>, debArg:VARARG
    LOCAL tmpLab,tmpStr
      pushad
      jmp    tmpLab

      tmpStr db debPat,CR,LF,NULL

    tmpLab:
      IFNB <debArg>
        INV wsprintf,OFS debTmpStr,OFS tmpStr,debArg
      ELSE
          INV lstrcpy,OFS debTmpStr,OFS tmpStr
      ENDIF

      INV debWriteConsole

      IF debDel ne 0
        INV Sleep,debDel
      ENDIF

      popad
  ENDM

  DEBUG MACRO debPat:REQ, debArg:VARARG
    DEBUGX debPat,0,debArg
  ENDM

  debWriteConsole proc
    LOCAL debTmpVar,debTmlLen:DWORD
      .if debHan==0
         INV    AllocConsole
         INV    GetStdHandle,STD_OUTPUT_HANDLE
         mov    debHan,eax
      .endif
      INV    lstrlen,OFS debTmpStr
      mov    debTmlLen,eax
      INV    WriteConsole,debHan,OFS debTmpStr,debTmlLen,\
             ADR debTmpVar,NULL
      INV    OutputDebugString,OFS debTmpStr

    ret
  debWriteConsole endp

  debInsGUID proc rcx:DWORD
    mov   ecx,rcx
    mov   al,[edx+ecx]
    shr   al,4
    lea   ebx,debHexChars
    xlatb
    mov   [edi],al
    inc   edi
    mov   al,[edx+ecx]
    and   al,15
    lea   ebx,debHexChars
    xlatb
    mov   [edi],al
    inc   edi            
    ret    
  debInsGUID endp

  debHexGUID proc riid:DWORD
    xor ecx,ecx
    mov edx,riid
    lea edi,debTmpBuf
    INV debInsGUID,3
    INV debInsGUID,2
    INV debInsGUID,1
    INV debInsGUID,0
    mov BPTR [edi],'-'
    inc edi
    INV debInsGUID,5
    INV debInsGUID,4
    mov BPTR [edi],'-'
    inc edi
    INV debInsGUID,7
    INV debInsGUID,6
    mov BPTR [edi],'-'
    inc edi
    INV debInsGUID,8
    INV debInsGUID,9
    mov BPTR [edi],'-'
    inc edi
    INV debInsGUID,10
    INV debInsGUID,11
    INV debInsGUID,12
    INV debInsGUID,13
    INV debInsGUID,14
    INV debInsGUID,15
    ret
  debHexGUID endp

  debGetLastError proc
    LOCAL  finBuf[1024]:BYTE
    LOCAL  errBuf:DWORD
      pushad

      mov    BPTR finBuf[0],NULL

      INV    GetLastError
      .IF eax!=0
        xchg eax,ecx
        INV FormatMessage,\
            FORMAT_MESSAGE_ALLOCATE_BUFFER+\
            FORMAT_MESSAGE_FROM_SYSTEM,0,ecx,\
            0,ADR errBuf,0,0
        INV lstrcat,ADR finBuf,errBuf
        INV LocalFree,errBuf
      .ENDIF

      DEBUG "GetLastError: %s",ADR finBuf

      popad
      ret
  debGetLastError endp

  DEBGLE MACRO
    INV  debGetLastError
  ENDM

  DEBUGGUID MACRO t
    pushad
    INV   debHexGUID,riid
    DEBUG t&" (%s)",OFS debTmpBuf
    popad
  ENDM

ELSE
   ;
   ; puste makra dla wersji RELEASE
   ;

  DEBUGX MACRO debPat:REQ, debDel:=<0>, debArg:VARARG
    ; puste makro DEBUGX dla wersji RELEASE
  ENDM

  DEBUG MACRO debPat:REQ, debugArgs:VARARG
    ; puste makro DEBUG dla wersji RELEASE
  ENDM

  DEBGLE MACRO
    ; puste makro DEBUGLE dla wersji RELEASE
  ENDM
  
  DEBUGGUID MACRO t
    ; puste makro DEBUGGUID dla wersji RELEASE
  ENDM
ENDIF

 UNI MACRO un,nv
   un label dword
   FORC c,<nv>
    dw '&c&'
   ENDM
    dw NULL
 ENDM

; ==========================================================
; makra wspomagajce wykorzystanie technologii COM i OLE
; ==========================================================

; ==========================================================
; makro pozwala wywoa metod danego interfejsu
; np. COM ShellTaskbar,ITaskbarList::AddTab,hWnd

 COM MACRO ppv,me,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,aa,ab,ac,ad,ae,af
    x EQU @InStr(1, <me>, <::>)
    rin SUBSTR <me>,1,x-1
    rme SUBSTR <me>,x+2
    rxx CATSTR rin,<Vtbl>,<.>,rme

     %ECHO COM - me
     FOR ar, <af,ae,ad,ac,ab,aa,a9,a8,a7,a6,a5,a4,a3,a2,a1,a0>
      IFNB <ar>
       IF @InStr(1,<ar>,<ADDR>) eq 0
         push ar
       ELSE
         txme SUBSTR <ar>,5
         lea eax,txme
         push eax
       ENDIF
      ENDIF
     ENDM
     mov  eax,DPTR [ppv]   ; adres do interfejsu
     mov  eax,[eax]        ; wskanik na tablice metod
     mov  eax,[eax.rxx]    ; adres do metody
     push ppv              ; wskanik obiektu (this)
     call eax              ; wywoujemy metod
 ENDM

; ==========================================================
; makro pozwala wygodnie deklarowa GUID
; np.
; XID CLSID_TaskbarList,'56FDF344-FD6D-11D0-958A-006097C9A090'

 XID MACRO gn,gv
  .data
  gn label dword
   xx SUBSTR <gv>,2,8
   dd @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,11,4
   dw @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,16,4
   dw @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,21,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,23,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,26,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,28,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,30,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,32,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,34,2
   db @CatStr(<0>,%xx,<h>)
   xx SUBSTR <gv>,36,2
   db @CatStr(<0>,%xx,<h>)
 ENDM

; ==========================================================
; makro definiuje struktur opisujc zadany interfejs COM

 INTERFACE_DEF MACRO interfejs,me:VARARG
   interfejs&Vtbl STRUC
    ; interfejs IUnknown
   QueryInterface         dd ?
   AddRef                 dd ?
   Release                dd ?

   FOR ar, <me>
    IFNB <ar>
      ar dd ?
    ENDIF
   ENDM

   interfejs&Vtbl ENDS

   interfejs STRUC
     lpVtbl dd ?
   interfejs ENDS

 ENDM

; ==========================================================
; makro definiuje struktur opisujc zadany interfejs COM
; dla interfejsw, ktrych - ze wzgldu na ograniczenie 
; asemblera - nie daje si zadeklarowa przy pomocy makra 
; INTERFACE_DEF - z reguy dotyczy to interfejsw, ktre
; udostpniaj wicej ni 10 metod

 INTERFACE_DEF_LONG_START MACRO interfejs
   interfejs&Vtbl STRUC
    ; interfejs IUnknown
   QueryInterface         dd ?
   AddRef                 dd ?
   Release                dd ?
 ENDM


; ==========================================================
; makro kontynuuje definicj interfejsu - w wywoaniu naley
; podawa kolejne metody interfejsu 

 INTERFACE_DEF_LONG_MET MACRO me:VARARG
   FOR ar, <me>
    IFNB <ar>
      ar dd ?
    ENDIF
   ENDM
 ENDM

; ==========================================================
; makro koczy definicj interfejsu
 
 INTERFACE_DEF_LONG_END MACRO interfejs
   interfejs&Vtbl ENDS

   interfejs STRUC
     lpVtbl dd ?
   interfejs ENDS

 ENDM

; ==========================================================
; interfejs ITaskbarList

 INTERFACE_DEF ITaskbarList,\
   HrInit,\
   AddTab,\
   DeleteTab,\
   ActivateTab,\
   SetActiveAlt

; ==========================================================
; interfejs IPersistFile

 INTERFACE_DEF IPersistFile,\
   GetClassID,\
   IsDirty,\
   Load,\
   Save,\
   SaveCompleted,\
   GetCurFile

; ==========================================================
; interfejs IShellLink

 INTERFACE_DEF IShellLink,\
   GetPath,\
   GetIDList,\
   SetIDList,\
   GetDescription,\
   SetDescription,\
   GetWorkingDirectory,\
   SetWorkingDirectory,\
   GetArguments,\
   SetArguments,\
   GetHotkey,\
   SetHotkey,\
   GetShowCmd,\
   SetShowCmd,\
   GetIconLocation,\
   SetIconLocation,\
   SetRelativePath,\
   Resolve,\
   SetPath

; ==========================================================
; stae dla metody IOleObject::DoVerb 
   OLEIVERB_PRIMARY            = 0
   OLEIVERB_SHOW               =-1
   OLEIVERB_OPEN               =-2
   OLEIVERB_HIDE               =-3
   OLEIVERB_UIACTIVATE         =-4
   OLEIVERB_INPLACEACTIVATE    =-5
   OLEIVERB_DISCARDUNDOSTATE   =-6

; ==========================================================
; interfejs IOleObject
 INTERFACE_DEF IOleObject,\
   SetClientSite,\
   GetClientSite,\
   SetHostNames,\
   Close,\
   SetMoniker,\
   GetMoniker,\
   InitFromData,\
   GetClipboardData,\
   DoVerb,\
   EnumVerbs,\
   Update,\
   IsUpToDate,\
   GetUserClassID,\
   GetUserType,\
   SetExtent,\
   GetExtent,\
   Advise,\
   Unadvise,\
   EnumAdvise,\
   GetMiscStatus,\
   SetColorScheme

; ==========================================================
; interfejs IOleClientSite
 INTERFACE_DEF IOleClientSite,\
   SaveObject,\
   GetMoniker,\
   GetContainer,\
   ShowObject,\
   OnShowWindow,\
   RequestNewObjectLayout

; ==========================================================
; interfejs IOleInPlaceFrame
 INTERFACE_DEF IOleInPlaceFrame,\
   GetWindow,\
   ContextSensitiveHelp,\
   GetBorder,\
   RequestBorderSpace,\
   SetBorderSpace,\
   SetActiveObject,\
   InsertMenus,\
   SetMenu,\
   RemoveMenus,\
   SetStatusText,\
   EnableModeless,\
   TranslateAccelerator 

; ==========================================================
; interfejs IOleInPlaceObject
 INTERFACE_DEF IOleInPlaceObject,\
    GetWindow,\
    ContextSensitiveHelp,\
    InPlaceDeactivate,\
    UIDeactivate,\
    SetObjectRects,\
    ReactivateAndUndo
   
; ==========================================================
; interfejs IOleInPlaceSite
 INTERFACE_DEF IOleInPlaceSite,\
   GetWindow,\
   ContextSensitiveHelp,\
   CanInPlaceActivate,\
   OnInPlaceActivate,\
   OnUIActivate,\
   GetWindowContext,\
   Scroll,\
   OnUIDeactivate,\
   OnInPlaceDeactivate,\
   DiscardUndoState,\
   DeactivateAndUndo,\
   OnPosRectChange

; ==========================================================
; interfejs IOleAdviseHolder
 INTERFACE_DEF IOleAdviseHolder,\
   Advise,\
   Unadvise,\
   EnumAdvise,\
   SendOnRename,\
   SendOnSave,\
   SendOnClose
 
; ==========================================================
; interfejs IAdviseSink
 INTERFACE_DEF IAdviseSink,\
   OnDataChange,\
   OnViewChange,\
   OnRename,\
   OnSave,\
   OnClose

; ==========================================================
; interfejs IWebBrowser2
 INTERFACE_DEF_LONG_START IWebBrowser2
 INTERFACE_DEF_LONG_MET,\
   GetTypeInfoCount,\
   GetTypeInfo,\
   GetIDsOfNames,\
   xInvoke,\
   GoBack,\
   GoForward,\
   GoHome,\
   GoSearch,\
   Navigate,\
   Refresh,\
   Refresh2,\
   Stop
 INTERFACE_DEF_LONG_MET,\
   get_Application,\
   get_Parent,\
   get_Container,\
   get_Document,\
   get_TopLevelContainer,\
   get_Type,\
   get_Left,\
   put_Left,\
   get_Top,\
   put_Top,\
   get_Width,\
   put_Width,\
   get_Height,\
   put_Height,\
   get_LocationName
 INTERFACE_DEF_LONG_MET,\
   get_LocationURL,\
   get_Busy,\
   Quit,\
   ClientToWindow,\
   PutProperty,\
   GetProperty,\
   get_Name,\
   get_HWND,\
   get_FullName,\
   get_Path,\
   get_Visible,\
   put_Visible,\
   get_StatusBar,\
   put_StatusBar,\
   get_StatusText,\
   put_StatusText,\
   get_ToolBar
 INTERFACE_DEF_LONG_MET,\
   put_ToolBar,\
   get_MenuBar,\
   put_MenuBar,\
   get_FullScreen,\
   put_FullScreen,\
   Navigate2,\
   QueryStatusWB,\
   ExecWB,\
   ShowBrowserBar,\
   get_ReadyState,\
   get_Offline,\
   put_Offline,\
   get_Silent,\
   put_Silent,\
   get_RegisterAsBrowser,\
   put_RegisterAsBrowser
 INTERFACE_DEF_LONG_MET,\
   get_RegisterAsDropTarget,\
   put_RegisterAsDropTarget,\
   get_TheaterMode,\
   put_TheaterMode,\
   get_AddressBar,\
   put_AddressBar,\
   get_Resizable,\
   put_Resizable
 INTERFACE_DEF_LONG_END IWebBrowser2
 
 OLEINPLACEFRAMEINFO struct
   cb            dd ?
   fMDIApp       dd ?
   hwndFrame     dd ?
   haccel        dd ?
   cAccelEntries dd ?
 OLEINPLACEFRAMEINFO ends  

