 ;
 ; ===========================================================
 ;  \Win32ASM\Src\UpTime\UpTime.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Odczytuje "Uptime" - czas, ktry upyn od
 ;               uruchomienia systemu; Tylko Win2000/XP!
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32
 INCLUDEX advapi32             ; uywamy ADVAPI32

 ID_DLG_MAIN   = 100
 ID_UPTIME     = 1003

.data?                         ; dane niezainicjalizowane
 hInstance dd ?
 hTimer    dd ?

.data                          ; dane zainicjalizowane
 szGlobal db 'Global',NULL
.code                          ; segment kodu (sekcja kodu)

   PDBINFO STRUCT
     pdb PERF_DATA_BLOCK <>
     pot PERF_OBJECT_TYPE <>
   PDBINFO ENDS

   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
    LOCAL pdbinfo:PDBINFO
    LOCAL bs,vt:DWORD
     pushad

     .IF  uMsg==WM_CLOSE
       INV KillTimer,hDlg,hTimer
       INV EndDialog,hDlg,0

     .ELSEIF uMsg==WM_TIMER
       mov bs,SIZEOF pdbinfo
       INV RegQueryValueEx,HKEY_PERFORMANCE_DATA,OFS szGlobal,\
           NULL,ADDR vt,ADDR pdbinfo,ADDR bs
       mov eax,DPTR [pdbinfo.pdb.Signature]    ;0E0P
       mov edx,DPTR [pdbinfo.pdb.Signature+4]  ;0F0R
       ror eax,8                       ;P0E0
       or eax,edx                      ;PFER
       .IF eax=="PFER"
           mov ebx,DPTR [pdbinfo.pdb.PerfFreq.QuadPart]
           mov eax,DPTR [pdbinfo.pdb.PerfTime.QuadPart]
           mov edx,DPTR [pdbinfo.pdb.PerfTime.QuadPart+4]
           push eax
           mov  eax,edx
           xor  edx,edx
           div  ebx
           mov  esi,eax
           pop  eax
           div  ebx
           mov  ebx,edx
           mov  edx,esi
           INV SetDlgItemInt,hDlg,ID_UPTIME,eax,FALSE
       .ENDIF
       INV RegCloseKey,HKEY_PERFORMANCE_DATA

     .ELSEIF uMsg==WM_INITDIALOG
       INV SetDlgItemInt,hDlg,ID_UPTIME,0,TRUE
       INV SendMessage,hDlg,WM_TIMER,0,0
       INV SetTimer,hDlg,0,1000,NULL
       mov hTimer,eax

     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==IDOK
          INV SendMessage,hDlg,WM_CLOSE,0,0
        .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                      ; pocztek programu

     INV GetModuleHandle,NULL
     mov hInstance,eax

     INV DialogBoxParam,hInstance,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV ExitProcess,0         ; powrt z programu

END Start                      ; tu zaczyna si program
